/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.selenium.endpoint;

import com.gargoylesoftware.htmlunit.BrowserVersion;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.apache.commons.io.FileUtils;
import org.citrusframework.context.TestContext;
import org.citrusframework.endpoint.AbstractEndpoint;
import org.citrusframework.endpoint.EndpointConfiguration;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.message.Message;
import org.citrusframework.messaging.Consumer;
import org.citrusframework.messaging.Producer;
import org.citrusframework.selenium.actions.SeleniumAction;
import org.citrusframework.selenium.endpoint.SeleniumBrowserConfiguration;
import org.citrusframework.spi.Resource;
import org.citrusframework.spi.Resources;
import org.citrusframework.util.StringUtils;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.chrome.ChromeOptions;
import org.openqa.selenium.edge.EdgeDriver;
import org.openqa.selenium.edge.EdgeOptions;
import org.openqa.selenium.firefox.FirefoxDriver;
import org.openqa.selenium.firefox.FirefoxOptions;
import org.openqa.selenium.firefox.FirefoxProfile;
import org.openqa.selenium.htmlunit.HtmlUnitDriver;
import org.openqa.selenium.ie.InternetExplorerDriver;
import org.openqa.selenium.ie.InternetExplorerOptions;
import org.openqa.selenium.remote.Browser;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.openqa.selenium.remote.UnreachableBrowserException;
import org.openqa.selenium.safari.SafariDriver;
import org.openqa.selenium.support.events.EventFiringDecorator;
import org.openqa.selenium.support.events.WebDriverListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SeleniumBrowser
extends AbstractEndpoint
implements Producer {
    private static final Logger logger = LoggerFactory.getLogger(SeleniumBrowser.class);
    private WebDriver webDriver;
    private final Path temporaryStorage = this.createTemporaryStorage();

    public SeleniumBrowser() {
        this(new SeleniumBrowserConfiguration());
    }

    public SeleniumBrowser(SeleniumBrowserConfiguration endpointConfiguration) {
        super((EndpointConfiguration)endpointConfiguration);
    }

    public void send(Message message, TestContext context) {
        SeleniumAction action = (SeleniumAction)message.getPayload(SeleniumAction.class);
        action.execute(context);
        logger.info("Selenium action successfully executed");
    }

    public void start() {
        if (!this.isStarted()) {
            this.webDriver = this.getEndpointConfiguration().getWebDriver() != null ? this.getEndpointConfiguration().getWebDriver() : (StringUtils.hasText((String)this.getEndpointConfiguration().getRemoteServerUrl()) ? this.createRemoteWebDriver(this.getEndpointConfiguration().getBrowserType(), this.getEndpointConfiguration().getRemoteServerUrl()) : this.createLocalWebDriver(this.getEndpointConfiguration().getBrowserType()));
            if (this.getEndpointConfiguration().getEventListeners() != null && !this.getEndpointConfiguration().getEventListeners().isEmpty()) {
                logger.info("Add event listeners to web driver: " + this.getEndpointConfiguration().getEventListeners().size());
                this.webDriver = new EventFiringDecorator(this.getEndpointConfiguration().getEventListeners().toArray(new WebDriverListener[0])).decorate(this.webDriver);
            }
        } else {
            logger.debug("Browser already started");
        }
    }

    public void stop() {
        if (this.isStarted()) {
            logger.info("Stopping browser " + this.webDriver.getCurrentUrl());
            try {
                logger.info("Trying to close the browser " + this.webDriver + " ...");
                this.webDriver.quit();
            }
            catch (UnreachableBrowserException e) {
                logger.warn("Browser is unreachable", (Throwable)e);
            }
            catch (WebDriverException e) {
                logger.error("Failed to close browser", (Throwable)e);
            }
            this.webDriver = null;
        } else {
            logger.warn("Browser already stopped");
        }
    }

    public String storeFile(String fileLocation) {
        return this.storeFile(Resources.create((String)fileLocation));
    }

    public String storeFile(Resource file) {
        try {
            File newFile = new File(this.temporaryStorage.toFile(), org.citrusframework.util.FileUtils.getFileName((String)file.getLocation()));
            logger.info("Store file " + file + " to " + newFile);
            FileUtils.copyFile((File)file.getFile(), (File)newFile);
            return newFile.getCanonicalPath();
        }
        catch (IOException e) {
            throw new CitrusRuntimeException("Failed to store file: " + file, (Throwable)e);
        }
    }

    public String getStoredFile(String filename) {
        try {
            File stored = new File(this.temporaryStorage.toFile(), filename);
            if (!stored.exists()) {
                throw new CitrusRuntimeException("Failed to access stored file: " + stored.getCanonicalPath());
            }
            return stored.getCanonicalPath();
        }
        catch (IOException e) {
            throw new CitrusRuntimeException("Failed to retrieve file: " + filename, (Throwable)e);
        }
    }

    private WebDriver createLocalWebDriver(String browserType) {
        if (Browser.FIREFOX.is(browserType)) {
            FirefoxProfile firefoxProfile = this.getEndpointConfiguration().getFirefoxProfile();
            firefoxProfile.setPreference("browser.download.dir", (Object)this.temporaryStorage.toFile().getAbsolutePath());
            return new FirefoxDriver(new FirefoxOptions().setProfile(firefoxProfile));
        }
        if (Browser.IE.is(browserType)) {
            return new InternetExplorerDriver();
        }
        if (Browser.EDGE.is(browserType)) {
            return new EdgeDriver();
        }
        if (Browser.SAFARI.is(browserType)) {
            return new SafariDriver();
        }
        if (Browser.CHROME.is(browserType)) {
            return new ChromeDriver();
        }
        if (Browser.HTMLUNIT.is(browserType)) {
            BrowserVersion browserVersion = null;
            switch (this.getEndpointConfiguration().getVersion()) {
                case "FIREFOX": {
                    browserVersion = BrowserVersion.FIREFOX;
                    break;
                }
                case "FIREFOX_78": 
                case "FIREFOX_ESR": {
                    browserVersion = BrowserVersion.FIREFOX_ESR;
                    break;
                }
                case "INTERNET_EXPLORER": {
                    browserVersion = BrowserVersion.INTERNET_EXPLORER;
                    break;
                }
                case "CHROME": {
                    browserVersion = BrowserVersion.CHROME;
                }
            }
            HtmlUnitDriver htmlUnitDriver = browserVersion != null ? new HtmlUnitDriver(browserVersion, this.getEndpointConfiguration().isJavaScript()) : new HtmlUnitDriver(this.getEndpointConfiguration().isJavaScript());
            return htmlUnitDriver;
        }
        throw new CitrusRuntimeException("Unsupported local browser type: " + browserType);
    }

    private RemoteWebDriver createRemoteWebDriver(String browserType, String serverAddress) {
        try {
            FirefoxOptions options;
            if (Browser.FIREFOX.is(browserType)) {
                options = new FirefoxOptions().setProfile(this.getEndpointConfiguration().getFirefoxProfile());
            } else {
                if (Browser.IE.is(browserType)) {
                    InternetExplorerOptions options2 = new InternetExplorerOptions();
                    options2.setCapability("acceptInsecureCerts", true);
                    return new RemoteWebDriver(new URL(serverAddress), (Capabilities)options2);
                }
                if (Browser.EDGE.is(browserType)) {
                    EdgeOptions options3 = new EdgeOptions();
                    options3.setCapability("acceptInsecureCerts", true);
                    return new RemoteWebDriver(new URL(serverAddress), (Capabilities)options3);
                }
                if (Browser.CHROME.is(browserType)) {
                    options = new ChromeOptions();
                    options.setCapability("acceptInsecureCerts", true);
                } else {
                    throw new CitrusRuntimeException("Unsupported remote browser type: " + browserType);
                }
            }
            return new RemoteWebDriver(new URL(serverAddress), (Capabilities)options);
        }
        catch (MalformedURLException e) {
            throw new CitrusRuntimeException("Failed to access remote server", (Throwable)e);
        }
    }

    private Path createTemporaryStorage() {
        try {
            Path tempDir = Files.createTempDirectory("selenium", new FileAttribute[0]);
            tempDir.toFile().deleteOnExit();
            logger.info("Download storage location is: " + tempDir);
            return tempDir;
        }
        catch (IOException e) {
            throw new CitrusRuntimeException("Could not create temporary storage", (Throwable)e);
        }
    }

    public WebDriver getWebDriver() {
        return this.webDriver;
    }

    public void setWebDriver(WebDriver webDriver) {
        this.webDriver = webDriver;
    }

    public boolean isStarted() {
        return this.webDriver != null;
    }

    public SeleniumBrowserConfiguration getEndpointConfiguration() {
        return (SeleniumBrowserConfiguration)super.getEndpointConfiguration();
    }

    public Producer createProducer() {
        return this;
    }

    public Consumer createConsumer() {
        throw new UnsupportedOperationException("Selenium browser must not be used as message consumer");
    }
}

