/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.selenium.xml;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import java.util.ArrayList;
import java.util.List;
import org.citrusframework.TestActor;
import org.citrusframework.selenium.actions.AbstractSeleniumAction;
import org.citrusframework.selenium.actions.PageAction;
import org.citrusframework.selenium.endpoint.SeleniumBrowser;
import org.citrusframework.selenium.model.PageValidator;
import org.citrusframework.selenium.model.WebPage;
import org.citrusframework.spi.ReferenceResolver;
import org.citrusframework.spi.ReferenceResolverAware;

@XmlRootElement(name="page")
public class Page
extends AbstractSeleniumAction.Builder<PageAction, Page>
implements ReferenceResolverAware {
    private final PageAction.Builder delegate = new PageAction.Builder();
    private String pageName;
    private String pageValidator;
    private ReferenceResolver referenceResolver;

    @XmlAttribute
    public void setName(String name) {
        this.pageName = name;
    }

    @XmlAttribute
    public void setType(String pageType) {
        this.delegate.type(pageType);
    }

    @XmlAttribute
    public void setAction(String action) {
        this.delegate.action(action);
    }

    @XmlAttribute
    public void setValidator(String pageValidator) {
        this.pageValidator = pageValidator;
    }

    @XmlAttribute(name="method")
    public void setExecute(String method) {
        this.delegate.action(method);
    }

    @XmlAttribute
    public void setArgument(String arg) {
        this.delegate.argument(arg);
    }

    @XmlElement(name="arguments")
    public void setArguments(Arguments args) {
        this.delegate.arguments(args.getArguments());
    }

    public Page description(String description) {
        this.delegate.description(description);
        return this;
    }

    public Page actor(TestActor actor) {
        this.delegate.actor(actor);
        return this;
    }

    @Override
    public Page browser(SeleniumBrowser seleniumBrowser) {
        this.delegate.browser(seleniumBrowser);
        return this;
    }

    public PageAction build() {
        if (this.referenceResolver != null) {
            if (this.pageName != null) {
                this.delegate.page((WebPage)this.referenceResolver.resolve(this.pageName, WebPage.class));
            }
            if (this.pageValidator != null) {
                this.delegate.validator((PageValidator)this.referenceResolver.resolve(this.pageValidator, PageValidator.class));
            }
        }
        return this.delegate.build();
    }

    public void setReferenceResolver(ReferenceResolver referenceResolver) {
        this.referenceResolver = referenceResolver;
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    @XmlType(name="", propOrder={"arguments"})
    public static class Arguments {
        @XmlElement(name="argument")
        private List<String> arguments;

        public List<String> getArguments() {
            if (this.arguments == null) {
                this.arguments = new ArrayList<String>();
            }
            return this.arguments;
        }

        public void setArguments(List<String> arguments) {
            this.arguments = arguments;
        }
    }
}

