/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.selenium.xml;

import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import org.citrusframework.TestAction;
import org.citrusframework.TestActionBuilder;
import org.citrusframework.TestActionContainerBuilder;
import org.citrusframework.TestActor;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.selenium.actions.AbstractSeleniumAction;
import org.citrusframework.selenium.actions.SeleniumAction;
import org.citrusframework.selenium.endpoint.SeleniumBrowser;
import org.citrusframework.selenium.xml.Alert;
import org.citrusframework.selenium.xml.CheckInput;
import org.citrusframework.selenium.xml.ClearBrowserCache;
import org.citrusframework.selenium.xml.Click;
import org.citrusframework.selenium.xml.CloseWindow;
import org.citrusframework.selenium.xml.DropDownSelect;
import org.citrusframework.selenium.xml.FindElement;
import org.citrusframework.selenium.xml.GetStoredFile;
import org.citrusframework.selenium.xml.Hover;
import org.citrusframework.selenium.xml.JavaScript;
import org.citrusframework.selenium.xml.MakeScreenshot;
import org.citrusframework.selenium.xml.Navigate;
import org.citrusframework.selenium.xml.OpenWindow;
import org.citrusframework.selenium.xml.Page;
import org.citrusframework.selenium.xml.SetInput;
import org.citrusframework.selenium.xml.StartBrowser;
import org.citrusframework.selenium.xml.StopBrowser;
import org.citrusframework.selenium.xml.StoreFile;
import org.citrusframework.selenium.xml.SwitchWindow;
import org.citrusframework.selenium.xml.WaitUntil;
import org.citrusframework.spi.ReferenceResolver;
import org.citrusframework.spi.ReferenceResolverAware;

@XmlRootElement(name="selenium")
public class Selenium
implements TestActionBuilder<TestAction>,
ReferenceResolverAware {
    private AbstractSeleniumAction.Builder<?, ?> builder;
    private String description;
    private String actor;
    private String seleniumBrowser;
    private ReferenceResolver referenceResolver;

    @XmlElement
    public Selenium setDescription(String value) {
        this.description = value;
        return this;
    }

    @XmlAttribute
    public Selenium setActor(String actor) {
        this.actor = actor;
        return this;
    }

    @XmlAttribute
    public Selenium setBrowser(String browser) {
        this.seleniumBrowser = browser;
        return this;
    }

    @XmlElement(name="start")
    public void setStart(StartBrowser builder) {
        this.builder = builder;
    }

    @XmlElement(name="stop")
    public void setStop(StopBrowser builder) {
        this.builder = builder;
    }

    @XmlElement(name="alert")
    public void setAlert(Alert builder) {
        this.builder = builder;
    }

    @XmlElement(name="navigate")
    public void setNavigate(Navigate builder) {
        this.builder = builder;
    }

    @XmlElement(name="page")
    public void setPage(Page builder) {
        this.builder = builder;
    }

    @XmlElement(name="find")
    public void setFind(FindElement builder) {
        this.builder = builder;
    }

    @XmlElement(name="dropdown-select")
    public void setDropdownSelect(DropDownSelect builder) {
        this.builder = builder;
    }

    @XmlElement(name="set-input")
    public void setSetInput(SetInput builder) {
        this.builder = builder;
    }

    @XmlElement(name="check-input")
    public void setCheckInput(CheckInput builder) {
        this.builder = builder;
    }

    @XmlElement(name="click")
    public void setClick(Click builder) {
        this.builder = builder;
    }

    @XmlElement(name="hover")
    public void setHover(Hover builder) {
        this.builder = builder;
    }

    @XmlElement(name="clear-cache")
    public void setClearCache(ClearBrowserCache builder) {
        this.builder = builder;
    }

    @XmlElement(name="screenshot")
    public void setScreenshot(MakeScreenshot builder) {
        this.builder = builder;
    }

    @XmlElement(name="store-file")
    public void setStoreFile(StoreFile builder) {
        this.builder = builder;
    }

    @XmlElement(name="get-stored-file")
    public void setGetStoredFile(GetStoredFile builder) {
        this.builder = builder;
    }

    @XmlElement(name="wait")
    public void setWaitUntil(WaitUntil builder) {
        this.builder = builder;
    }

    @XmlElement(name="javascript")
    public void setJavascript(JavaScript builder) {
        this.builder = builder;
    }

    @XmlElement(name="open-window")
    public void setOpenWindow(OpenWindow builder) {
        this.builder = builder;
    }

    @XmlElement(name="close-window")
    public void setCloseWindow(CloseWindow builder) {
        this.builder = builder;
    }

    @XmlElement(name="focus-window")
    public void setFocusWindow(SwitchWindow builder) {
        this.builder = builder;
    }

    @XmlElement(name="switch-window")
    public void setSwitchWindow(SwitchWindow builder) {
        this.builder = builder;
    }

    public SeleniumAction build() {
        if (this.builder == null) {
            throw new CitrusRuntimeException("Missing Selenium action - please provide proper action details");
        }
        if (this.builder instanceof TestActionContainerBuilder) {
            ((TestActionContainerBuilder)this.builder).getActions().stream().filter(action -> action instanceof ReferenceResolverAware).forEach(action -> ((ReferenceResolverAware)action).setReferenceResolver(this.referenceResolver));
        }
        if (this.builder instanceof ReferenceResolverAware) {
            ((ReferenceResolverAware)this.builder).setReferenceResolver(this.referenceResolver);
        }
        this.builder.description(this.description);
        if (this.referenceResolver != null) {
            if (this.seleniumBrowser != null) {
                this.builder.browser((SeleniumBrowser)((Object)this.referenceResolver.resolve(this.seleniumBrowser, SeleniumBrowser.class)));
            }
            if (this.actor != null) {
                this.builder.actor((TestActor)this.referenceResolver.resolve(this.actor, TestActor.class));
            }
        }
        return (SeleniumAction)this.builder.build();
    }

    public void setReferenceResolver(ReferenceResolver referenceResolver) {
        this.referenceResolver = referenceResolver;
    }
}

