/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.selenium.yaml;

import java.util.ArrayList;
import java.util.List;
import org.citrusframework.TestActor;
import org.citrusframework.selenium.actions.AbstractSeleniumAction;
import org.citrusframework.selenium.actions.FindElementAction;
import org.citrusframework.selenium.endpoint.SeleniumBrowser;
import org.citrusframework.selenium.yaml.ElementAware;

public class FindElement
extends AbstractSeleniumAction.Builder<FindElementAction, FindElement>
implements ElementAware {
    private final FindElementAction.Builder delegate = new FindElementAction.Builder();

    @Override
    public void setElement(ElementAware.Element element) {
        ElementAware.super.setElement(element);
    }

    public void setValidate(Validate validate) {
        if (validate.getText() != null) {
            this.delegate.text(validate.text);
        }
        if (validate.getTagName() != null) {
            this.delegate.tagName(validate.tagName);
        }
        this.delegate.enabled(validate.enabled);
        this.delegate.displayed(validate.displayed);
        for (Attribute attribute : validate.getAttributes()) {
            this.delegate.attribute(attribute.getName(), attribute.getValue());
        }
        for (Style style : validate.getStyles()) {
            this.delegate.style(style.getName(), style.getValue());
        }
    }

    @Override
    public FindElementAction.ElementActionBuilder<?, ?> getElementBuilder() {
        return this.delegate;
    }

    public FindElement description(String description) {
        this.delegate.description(description);
        return this;
    }

    public FindElement actor(TestActor actor) {
        this.delegate.actor(actor);
        return this;
    }

    @Override
    public FindElement browser(SeleniumBrowser seleniumBrowser) {
        this.delegate.browser(seleniumBrowser);
        return this;
    }

    public FindElementAction build() {
        return this.delegate.build();
    }

    public static class Validate {
        private String text;
        private String tagName;
        private boolean displayed = true;
        private boolean enabled = true;
        private List<Attribute> attributes;
        private List<Style> styles;

        public String getText() {
            return this.text;
        }

        public void setText(String text) {
            this.text = text;
        }

        public String getTagName() {
            return this.tagName;
        }

        public void setTagName(String tagName) {
            this.tagName = tagName;
        }

        public List<Attribute> getAttributes() {
            if (this.attributes == null) {
                this.attributes = new ArrayList<Attribute>();
            }
            return this.attributes;
        }

        public void setAttributes(List<Attribute> attributes) {
            this.attributes = attributes;
        }

        public List<Style> getStyles() {
            if (this.styles == null) {
                this.styles = new ArrayList<Style>();
            }
            return this.styles;
        }

        public void setStyles(List<Style> styles) {
            this.styles = styles;
        }

        public boolean isDisplayed() {
            return this.displayed;
        }

        public void setDisplayed(boolean displayed) {
            this.displayed = displayed;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }
    }

    public static class Attribute {
        private String name;
        private String value;

        public void setName(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static class Style {
        private String name;
        private String value;

        public void setName(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }
}

