/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.selenium.yaml;

import java.util.List;
import org.citrusframework.TestActor;
import org.citrusframework.selenium.actions.AbstractSeleniumAction;
import org.citrusframework.selenium.actions.PageAction;
import org.citrusframework.selenium.endpoint.SeleniumBrowser;
import org.citrusframework.selenium.model.PageValidator;
import org.citrusframework.selenium.model.WebPage;
import org.citrusframework.spi.ReferenceResolver;
import org.citrusframework.spi.ReferenceResolverAware;

public class Page
extends AbstractSeleniumAction.Builder<PageAction, Page>
implements ReferenceResolverAware {
    private final PageAction.Builder delegate = new PageAction.Builder();
    private String pageName;
    private String pageValidator;
    private ReferenceResolver referenceResolver;

    public void setName(String name) {
        this.pageName = name;
    }

    public void setType(String pageType) {
        this.delegate.type(pageType);
    }

    public void setAction(String action) {
        this.delegate.action(action);
    }

    public void setValidate() {
        this.delegate.action("validate");
    }

    public void setValidator(String pageValidator) {
        this.pageValidator = pageValidator;
    }

    public void setExecute(String method) {
        this.delegate.action(method);
    }

    public void setArgument(String arg) {
        this.delegate.argument(arg);
    }

    public void setArguments(List<String> args) {
        this.delegate.arguments(args);
    }

    public Page description(String description) {
        this.delegate.description(description);
        return this;
    }

    public Page actor(TestActor actor) {
        this.delegate.actor(actor);
        return this;
    }

    @Override
    public Page browser(SeleniumBrowser seleniumBrowser) {
        this.delegate.browser(seleniumBrowser);
        return this;
    }

    public PageAction build() {
        if (this.referenceResolver != null) {
            if (this.pageName != null) {
                this.delegate.page((WebPage)this.referenceResolver.resolve(this.pageName, WebPage.class));
            }
            if (this.pageValidator != null) {
                this.delegate.validator((PageValidator)this.referenceResolver.resolve(this.pageValidator, PageValidator.class));
            }
        }
        return this.delegate.build();
    }

    public void setReferenceResolver(ReferenceResolver referenceResolver) {
        this.referenceResolver = referenceResolver;
    }
}

