/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.selenium.actions;

import org.citrusframework.AbstractTestActionBuilder;
import org.citrusframework.actions.AbstractTestAction;
import org.citrusframework.actions.selenium.SeleniumActionBuilderBase;
import org.citrusframework.context.TestContext;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.selenium.actions.SeleniumAction;
import org.citrusframework.selenium.endpoint.SeleniumBrowser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSeleniumAction
extends AbstractTestAction
implements SeleniumAction {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final SeleniumBrowser browser;

    public AbstractSeleniumAction(String name, Builder<?, ?> builder) {
        super("selenium:" + name, builder);
        this.browser = builder.browser;
    }

    public void doExecute(TestContext context) {
        SeleniumBrowser browserToUse;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(String.format("Executing Selenium browser command '%s'", this.getName()));
        }
        if ((browserToUse = this.browser) == null) {
            if (context.getVariables().containsKey("selenium_browser")) {
                browserToUse = (SeleniumBrowser)((Object)context.getReferenceResolver().resolve(context.getVariable("selenium_browser"), SeleniumBrowser.class));
            } else {
                throw new CitrusRuntimeException("Failed to get active browser instance, either set explicit browser for action or start browser instance");
            }
        }
        this.execute(browserToUse, context);
        this.logger.info(String.format("Selenium browser command execution successful: '%s'", this.getName()));
    }

    protected abstract void execute(SeleniumBrowser var1, TestContext var2);

    @Override
    public SeleniumBrowser getBrowser() {
        return this.browser;
    }

    public static abstract class Builder<T extends SeleniumAction, B extends Builder<T, B>>
    extends AbstractTestActionBuilder<T, B>
    implements SeleniumActionBuilderBase<T, B> {
        private SeleniumBrowser browser;

        public B browser(SeleniumBrowser seleniumBrowser) {
            this.browser = seleniumBrowser;
            return (B)((Object)((Builder)this.self));
        }

        public B browser(Object o) {
            SeleniumBrowser seleniumBrowser;
            if (!(o instanceof SeleniumBrowser)) {
                throw new CitrusRuntimeException("Invalid browser object, expected be a SeleniumBrowser, but got %s".formatted(o.getClass().getName()));
            }
            this.browser = seleniumBrowser = (SeleniumBrowser)((Object)o);
            return (B)((Object)((Builder)this.self));
        }
    }
}

