/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.selenium.actions;

import org.citrusframework.actions.selenium.SeleniumAlertActionBuilder;
import org.citrusframework.context.TestContext;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.exceptions.ValidationException;
import org.citrusframework.selenium.actions.AbstractSeleniumAction;
import org.citrusframework.selenium.endpoint.SeleniumBrowser;
import org.citrusframework.util.StringUtils;
import org.citrusframework.validation.matcher.ValidationMatcherUtils;
import org.openqa.selenium.Alert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AlertAction
extends AbstractSeleniumAction {
    private static final Logger logger = LoggerFactory.getLogger(AlertAction.class);
    private final boolean accept;
    private final String text;

    public AlertAction(Builder builder) {
        super("alert", builder);
        this.accept = builder.accept;
        this.text = builder.text;
    }

    @Override
    protected void execute(SeleniumBrowser browser, TestContext context) {
        Alert alert = browser.getWebDriver().switchTo().alert();
        if (alert == null) {
            throw new CitrusRuntimeException("Failed to access alert dialog - not found");
        }
        if (StringUtils.hasText((String)this.text)) {
            logger.info("Validating alert text");
            String alertText = context.replaceDynamicContentInString(this.text);
            if (ValidationMatcherUtils.isValidationMatcherExpression((String)alertText)) {
                ValidationMatcherUtils.resolveValidationMatcher((String)"alertText", (String)alert.getText(), (String)alertText, (TestContext)context);
            } else if (!alertText.equals(alert.getText())) {
                throw new ValidationException(String.format("Failed to validate alert dialog text, expected '%s', but was '%s'", alertText, alert.getText()));
            }
            logger.debug("Alert text validation successful - All values Ok");
        }
        context.setVariable("selenium_alert_text", (Object)alert.getText());
        if (this.accept) {
            alert.accept();
        } else {
            alert.dismiss();
        }
    }

    public boolean isAccept() {
        return this.accept;
    }

    public String getText() {
        return this.text;
    }

    public static class Builder
    extends AbstractSeleniumAction.Builder<AlertAction, Builder>
    implements SeleniumAlertActionBuilder<AlertAction, Builder> {
        private boolean accept = true;
        private String text;

        public Builder text(String text) {
            this.text = text;
            return this;
        }

        public Builder accept() {
            this.accept = true;
            return this;
        }

        public Builder dismiss() {
            this.accept = false;
            return this;
        }

        public AlertAction build() {
            return new AlertAction(this);
        }
    }
}

