/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.selenium.actions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.citrusframework.actions.selenium.SeleniumDropDownSelectActionBuilder;
import org.citrusframework.context.TestContext;
import org.citrusframework.selenium.actions.FindElementAction;
import org.citrusframework.selenium.endpoint.SeleniumBrowser;
import org.citrusframework.util.StringUtils;
import org.openqa.selenium.Keys;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.interactions.Action;
import org.openqa.selenium.interactions.Actions;
import org.openqa.selenium.remote.Browser;
import org.openqa.selenium.support.ui.Select;

public class DropDownSelectAction
extends FindElementAction {
    private final String option;
    private final List<String> options;

    public DropDownSelectAction(Builder builder) {
        super("dropdown-select", builder);
        this.option = builder.option;
        this.options = builder.options;
    }

    @Override
    protected void execute(WebElement webElement, SeleniumBrowser browser, TestContext context) {
        super.execute(webElement, browser, context);
        Select dropdown = new Select(webElement);
        if (StringUtils.hasText((String)this.option)) {
            dropdown.selectByValue(context.replaceDynamicContentInString(this.option));
        }
        if (this.options != null && !this.options.isEmpty()) {
            if (Browser.IE.is(browser.getEndpointConfiguration().getBrowserType())) {
                for (String option : this.options) {
                    dropdown.selectByValue(context.replaceDynamicContentInString(option));
                }
            } else {
                List optionElements = dropdown.getOptions();
                Actions builder = new Actions(browser.getWebDriver());
                builder.keyDown((CharSequence)Keys.CONTROL);
                for (String optionValue : this.options) {
                    for (WebElement option : optionElements) {
                        if (option.isSelected() || !this.isSameValue(option, context.replaceDynamicContentInString(optionValue))) continue;
                        builder.moveToElement(option).click(option);
                    }
                }
                builder.keyUp((CharSequence)Keys.CONTROL);
                Action multiple = builder.build();
                multiple.perform();
            }
        }
    }

    private boolean isSameValue(WebElement option, String value) {
        if (StringUtils.hasText((String)option.getText())) {
            return value.equals(option.getText());
        }
        return value.equals(option.getAttribute("value"));
    }

    public String getOption() {
        return this.option;
    }

    public List<String> getOptions() {
        return this.options;
    }

    public static class Builder
    extends FindElementAction.ElementActionBuilder<DropDownSelectAction, Builder>
    implements SeleniumDropDownSelectActionBuilder<DropDownSelectAction, Builder> {
        private String option;
        private final List<String> options = new ArrayList<String>();

        public Builder option(String option) {
            this.option = option;
            return this;
        }

        public Builder options(String ... options) {
            return this.options((List)Arrays.asList(options));
        }

        public Builder options(List<String> options) {
            this.options.addAll(options);
            return this;
        }

        public DropDownSelectAction build() {
            return new DropDownSelectAction(this);
        }
    }
}

