/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.selenium.actions;

import java.util.LinkedHashMap;
import java.util.Map;
import org.citrusframework.actions.selenium.SeleniumFillFormActionBuilder;
import org.citrusframework.context.TestContext;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.selenium.actions.AbstractSeleniumAction;
import org.citrusframework.selenium.actions.ClickAction;
import org.citrusframework.selenium.actions.SetInputAction;
import org.citrusframework.selenium.endpoint.SeleniumBrowser;
import org.openqa.selenium.By;
import org.openqa.selenium.json.Json;

public class FillFormAction
extends AbstractSeleniumAction {
    private final Map<By, String> formFields;
    private final By submitButton;

    public FillFormAction(Builder builder) {
        super("fill-form", builder);
        this.formFields = builder.formFields;
        this.submitButton = builder.submitButton;
    }

    @Override
    public void execute(SeleniumBrowser browser, TestContext context) {
        this.formFields.forEach((by, value) -> ((SetInputAction.Builder)((Object)((Object)new SetInputAction.Builder().element((By)by)))).value((String)value).build().execute(browser, context));
        if (this.submitButton != null) {
            ((ClickAction.Builder)((Object)new ClickAction.Builder().element(this.submitButton))).build().execute(browser, context);
        }
    }

    public Map<By, String> getFormFields() {
        return this.formFields;
    }

    public By getSubmitButton() {
        return this.submitButton;
    }

    public static class Builder
    extends AbstractSeleniumAction.Builder<FillFormAction, Builder>
    implements SeleniumFillFormActionBuilder<FillFormAction, Builder> {
        private final Map<By, String> formFields = new LinkedHashMap<By, String>();
        private By submitButton;

        public Builder field(By by, String value) {
            this.formFields.put(by, value);
            return this;
        }

        public Builder field(Object o, String value) {
            if (!(o instanceof By)) {
                throw new CitrusRuntimeException("Invalid field object, expected to be a By object, but got %s".formatted(o.getClass().getName()));
            }
            By by = (By)o;
            this.formFields.put(by, value);
            return this;
        }

        public Builder field(String id, String value) {
            return this.field(By.id((String)id), value);
        }

        public Builder fromJson(String formFieldsJson) {
            return this.fields((Map)new Json().toType(formFieldsJson, Map.class));
        }

        public Builder submit() {
            this.submitButton = By.xpath((String)"//input[@type='submit']");
            return this;
        }

        public Builder submit(String id) {
            return this.submit(By.id((String)id));
        }

        public Builder submit(By button) {
            this.submitButton = button;
            return this;
        }

        public Builder submit(Object o) {
            By button;
            if (!(o instanceof By)) {
                throw new CitrusRuntimeException("Invalid button object, expected to be a By object, but got %s".formatted(o.getClass().getName()));
            }
            this.submitButton = button = (By)o;
            return this;
        }

        public Builder fields(Map<String, String> fields) {
            fields.forEach(this::field);
            return this;
        }

        public FillFormAction build() {
            return new FillFormAction(this);
        }
    }
}

