/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.selenium.actions;

import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.citrusframework.actions.selenium.SeleniumJavaScriptActionBuilder;
import org.citrusframework.context.TestContext;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.exceptions.ValidationException;
import org.citrusframework.selenium.actions.AbstractSeleniumAction;
import org.citrusframework.selenium.endpoint.SeleniumBrowser;
import org.citrusframework.spi.Resource;
import org.citrusframework.util.FileUtils;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaScriptAction
extends AbstractSeleniumAction {
    private static final Logger logger = LoggerFactory.getLogger(JavaScriptAction.class);
    private final String script;
    private final List<Object> arguments;
    private final List<String> expectedErrors;

    public JavaScriptAction(Builder builder) {
        super("javascript", builder);
        this.script = builder.script;
        this.arguments = builder.arguments;
        this.expectedErrors = builder.expectedErrors;
    }

    @Override
    protected void execute(SeleniumBrowser browser, TestContext context) {
        try {
            WebDriver webDriver = browser.getWebDriver();
            if (webDriver instanceof JavascriptExecutor) {
                JavascriptExecutor jsEngine = (JavascriptExecutor)webDriver;
                jsEngine.executeScript(context.replaceDynamicContentInString(this.script), context.resolveDynamicValuesInArray(this.arguments.toArray()));
                ArrayList<String> errors = new ArrayList<String>();
                List errorObjects = (List)jsEngine.executeScript("return window._selenide_jsErrors", new Object[0]);
                if (errorObjects != null) {
                    for (Object error : errorObjects) {
                        errors.add(error.toString());
                    }
                }
                context.setVariable("selenium_js_errors", errors);
                for (String expected : this.expectedErrors) {
                    if (errors.contains(expected)) continue;
                    throw new ValidationException("Missing JavaScript error " + expected);
                }
            } else {
                logger.warn("Skip javascript action because web driver is missing javascript features");
            }
        }
        catch (WebDriverException e) {
            throw new CitrusRuntimeException("Failed to execute JavaScript code", (Throwable)e);
        }
    }

    public String getScript() {
        return this.script;
    }

    public List<Object> getArguments() {
        return this.arguments;
    }

    public List<String> getExpectedErrors() {
        return this.expectedErrors;
    }

    public static class Builder
    extends AbstractSeleniumAction.Builder<JavaScriptAction, Builder>
    implements SeleniumJavaScriptActionBuilder<JavaScriptAction, Builder> {
        private String script;
        private final List<Object> arguments = new ArrayList<Object>();
        private final List<String> expectedErrors = new ArrayList<String>();

        public Builder script(String script) {
            this.script = script;
            return this;
        }

        public Builder script(Resource resource) {
            return this.script(resource, FileUtils.getDefaultCharset());
        }

        public Builder script(Resource resource, Charset charset) {
            try {
                return this.script(FileUtils.readToString((Resource)resource, (Charset)charset));
            }
            catch (IOException e) {
                throw new CitrusRuntimeException("Failed to read script resource", (Throwable)e);
            }
        }

        public Builder arguments(Object ... args) {
            return this.arguments((List)Arrays.asList(args));
        }

        public Builder arguments(List<Object> args) {
            this.arguments.addAll(args);
            return this;
        }

        public Builder argument(Object arg) {
            this.arguments.add(arg);
            return this;
        }

        public Builder errors(String ... errors) {
            return this.errors((List)Arrays.asList(errors));
        }

        public Builder errors(List<String> errors) {
            this.expectedErrors.addAll(errors);
            return this;
        }

        public Builder error(String error) {
            this.expectedErrors.add(error);
            return this;
        }

        public JavaScriptAction build() {
            return new JavaScriptAction(this);
        }
    }
}

