/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.selenium.actions;

import java.util.Set;
import org.citrusframework.actions.selenium.SeleniumOpenWindowActionBuilder;
import org.citrusframework.context.TestContext;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.selenium.actions.AbstractSeleniumAction;
import org.citrusframework.selenium.endpoint.SeleniumBrowser;
import org.citrusframework.util.StringUtils;
import org.openqa.selenium.JavascriptExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenWindowAction
extends AbstractSeleniumAction {
    private static final Logger logger = LoggerFactory.getLogger(OpenWindowAction.class);
    private final String windowName;

    public OpenWindowAction(Builder builder) {
        super("open-window", builder);
        this.windowName = builder.windowName;
    }

    @Override
    protected void execute(SeleniumBrowser browser, TestContext context) {
        Set windowHandles = browser.getWebDriver().getWindowHandles();
        String newWindow = null;
        String lastWindow = browser.getWebDriver().getWindowHandle();
        context.setVariable("selenium_last_window", (Object)lastWindow);
        if (browser.getWebDriver() instanceof JavascriptExecutor) {
            ((JavascriptExecutor)browser.getWebDriver()).executeScript("window.open();", new Object[0]);
        }
        Set newWindowHandles = browser.getWebDriver().getWindowHandles();
        for (String window : newWindowHandles) {
            if (windowHandles.contains(window)) continue;
            newWindow = window;
        }
        if (StringUtils.isEmpty(newWindow)) {
            throw new CitrusRuntimeException("Failed to open new window");
        }
        browser.getWebDriver().switchTo().window(newWindow);
        logger.info("Open window: " + newWindow);
        context.setVariable("selenium_active_window", (Object)newWindow);
        context.setVariable(this.windowName, (Object)newWindow);
    }

    public String getWindowName() {
        return this.windowName;
    }

    public static class Builder
    extends AbstractSeleniumAction.Builder<OpenWindowAction, Builder>
    implements SeleniumOpenWindowActionBuilder<OpenWindowAction, Builder> {
        private String windowName = "selenium_active_window";

        public Builder window(String name) {
            this.windowName = name;
            return this;
        }

        public OpenWindowAction build() {
            return new OpenWindowAction(this);
        }
    }
}

