/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.selenium.actions;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.citrusframework.actions.selenium.PageValidator;
import org.citrusframework.actions.selenium.SeleniumPageActionBuilder;
import org.citrusframework.actions.selenium.WebPage;
import org.citrusframework.context.TestContext;
import org.citrusframework.endpoint.Endpoint;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.selenium.actions.AbstractSeleniumAction;
import org.citrusframework.selenium.endpoint.SeleniumBrowser;
import org.citrusframework.util.ReflectionHelper;
import org.citrusframework.util.StringUtils;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.support.PageFactory;

public class PageAction
extends AbstractSeleniumAction {
    private final WebPage page;
    private final String type;
    private final String action;
    private final List<String> arguments;
    private final PageValidator<?, ?> validator;

    public PageAction(Builder builder) {
        super("page", builder);
        this.page = builder.page;
        this.type = builder.type;
        this.action = builder.action;
        this.arguments = builder.arguments;
        this.validator = builder.validator;
    }

    @Override
    protected void execute(SeleniumBrowser browser, TestContext context) {
        WebPage pageToUse;
        if (StringUtils.hasText((String)this.type)) {
            try {
                pageToUse = (WebPage)Class.forName(context.replaceDynamicContentInString(this.type)).newInstance();
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                throw new CitrusRuntimeException(String.format("Failed to access page type '%s'", context.replaceDynamicContentInString(this.type)), (Throwable)e);
            }
        } else {
            pageToUse = this.page;
        }
        PageFactory.initElements((SearchContext)browser.getWebDriver(), (Object)pageToUse);
        if (StringUtils.hasText((String)this.action)) {
            if (this.action.equals("validate")) {
                if (this.validator == null && !(pageToUse instanceof PageValidator)) {
                    throw new CitrusRuntimeException(String.format("Missing page validator for action '%s'", this.action));
                }
                if (this.validator != null) {
                    this.validator.adaptAndValidate(pageToUse, (Endpoint)browser, context);
                }
                if (pageToUse instanceof PageValidator) {
                    ((PageValidator)pageToUse).adaptAndValidate(pageToUse, (Endpoint)browser, context);
                }
            } else {
                ReflectionHelper.doWithMethods(pageToUse.getClass(), method -> {
                    if (method.getName().equals(this.action)) {
                        if (method.getParameterCount() == 0 && this.arguments.size() == 0) {
                            ReflectionHelper.invokeMethod((Method)method, (Object)pageToUse, (Object[])new Object[0]);
                        } else if (method.getParameterCount() == 1 && method.getParameters()[0].getParameterizedType().getTypeName().equals(TestContext.class.getName())) {
                            ReflectionHelper.invokeMethod((Method)method, (Object)pageToUse, (Object[])new Object[]{context});
                        } else if (method.getParameterCount() == this.arguments.size()) {
                            ReflectionHelper.invokeMethod((Method)method, (Object)pageToUse, (Object[])context.resolveDynamicValuesInList(this.arguments).toArray());
                        } else if (method.getParameterCount() == this.arguments.size() + 1) {
                            Object[] args = Arrays.copyOf(this.arguments.toArray(), this.arguments.size() + 1);
                            args[this.arguments.size()] = context;
                            ReflectionHelper.invokeMethod((Method)method, (Object)pageToUse, (Object[])context.resolveDynamicValuesInArray(args));
                        } else {
                            throw new CitrusRuntimeException("Unsupported method signature for page action - not matching given arguments");
                        }
                    }
                });
            }
        }
    }

    public WebPage getPage() {
        return this.page;
    }

    public String getAction() {
        return this.action;
    }

    public PageValidator<?, ?> getValidator() {
        return this.validator;
    }

    public String getType() {
        return this.type;
    }

    public List<String> getArguments() {
        return this.arguments;
    }

    public static class Builder
    extends AbstractSeleniumAction.Builder<PageAction, Builder>
    implements SeleniumPageActionBuilder<PageAction, Builder> {
        private WebPage page;
        private String type;
        private String action;
        private final List<String> arguments = new ArrayList<String>();
        private PageValidator<?, ?> validator;

        public Builder page(WebPage page) {
            this.page = page;
            return this;
        }

        public Builder type(String pageType) {
            this.type = pageType;
            return this;
        }

        public Builder type(Class<? extends WebPage> pageType) {
            if (!WebPage.class.isAssignableFrom(pageType)) {
                throw new CitrusRuntimeException("Page type must be WebPage, but got %s".formatted(pageType.getName()));
            }
            this.type = pageType.getName();
            return this;
        }

        public Builder action(String action) {
            this.action = action;
            return this;
        }

        public Builder validate() {
            this.action = "validate";
            return this;
        }

        public Builder validator(PageValidator<?, ?> validator) {
            this.validator = validator;
            return this;
        }

        public Builder execute(String method) {
            this.action = method;
            return this;
        }

        public Builder argument(String arg) {
            this.arguments.add(arg);
            return this;
        }

        public Builder arguments(String ... args) {
            return this.arguments((List)Arrays.asList(args));
        }

        public Builder arguments(List<String> args) {
            this.arguments.addAll(args);
            return this;
        }

        public PageAction build() {
            return new PageAction(this);
        }
    }
}

