/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.selenium.actions;

import org.citrusframework.TestActionBuilder;
import org.citrusframework.endpoint.Endpoint;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.selenium.actions.AbstractSeleniumAction;
import org.citrusframework.selenium.actions.AlertAction;
import org.citrusframework.selenium.actions.CheckInputAction;
import org.citrusframework.selenium.actions.ClearBrowserCacheAction;
import org.citrusframework.selenium.actions.ClickAction;
import org.citrusframework.selenium.actions.CloseWindowAction;
import org.citrusframework.selenium.actions.DropDownSelectAction;
import org.citrusframework.selenium.actions.FillFormAction;
import org.citrusframework.selenium.actions.FindElementAction;
import org.citrusframework.selenium.actions.GetStoredFileAction;
import org.citrusframework.selenium.actions.HoverAction;
import org.citrusframework.selenium.actions.JavaScriptAction;
import org.citrusframework.selenium.actions.MakeScreenshotAction;
import org.citrusframework.selenium.actions.NavigateAction;
import org.citrusframework.selenium.actions.OpenWindowAction;
import org.citrusframework.selenium.actions.PageAction;
import org.citrusframework.selenium.actions.SeleniumAction;
import org.citrusframework.selenium.actions.SetInputAction;
import org.citrusframework.selenium.actions.StartBrowserAction;
import org.citrusframework.selenium.actions.StopBrowserAction;
import org.citrusframework.selenium.actions.StoreFileAction;
import org.citrusframework.selenium.actions.SwitchWindowAction;
import org.citrusframework.selenium.actions.WaitUntilAction;
import org.citrusframework.selenium.endpoint.SeleniumBrowser;
import org.citrusframework.util.ObjectHelper;

public class SeleniumActionBuilder
implements TestActionBuilder.DelegatingTestActionBuilder<SeleniumAction>,
org.citrusframework.actions.selenium.SeleniumActionBuilder<SeleniumAction, SeleniumActionBuilder> {
    private SeleniumBrowser seleniumBrowser;
    private AbstractSeleniumAction.Builder<? extends SeleniumAction, ?> delegate;

    public static SeleniumActionBuilder selenium() {
        return new SeleniumActionBuilder();
    }

    public SeleniumActionBuilder browser(SeleniumBrowser seleniumBrowser) {
        this.seleniumBrowser = seleniumBrowser;
        return this;
    }

    public SeleniumActionBuilder browser(Endpoint endpoint) {
        if (endpoint instanceof SeleniumBrowser) {
            SeleniumBrowser browser = (SeleniumBrowser)endpoint;
            return this.browser(browser);
        }
        throw new CitrusRuntimeException("Invalid browser object, expected a SeleniumBrowser, but got %s".formatted(endpoint.getClass().getName()));
    }

    public StartBrowserAction.Builder start() {
        StartBrowserAction.Builder builder;
        this.delegate = builder = (StartBrowserAction.Builder)((Object)new StartBrowserAction.Builder().browser(this.seleniumBrowser));
        return builder;
    }

    public StartBrowserAction.Builder start(SeleniumBrowser seleniumBrowser) {
        StartBrowserAction.Builder builder;
        this.browser(seleniumBrowser);
        this.delegate = builder = (StartBrowserAction.Builder)((Object)new StartBrowserAction.Builder().browser(seleniumBrowser));
        return builder;
    }

    public StartBrowserAction.Builder start(Endpoint endpoint) {
        if (endpoint instanceof SeleniumBrowser) {
            SeleniumBrowser browser = (SeleniumBrowser)endpoint;
            return this.start(browser);
        }
        throw new CitrusRuntimeException("Invalid browser object, expected a SeleniumBrowser, but got %s".formatted(endpoint.getClass().getName()));
    }

    public StopBrowserAction.Builder stop() {
        StopBrowserAction.Builder builder;
        this.delegate = builder = (StopBrowserAction.Builder)((Object)new StopBrowserAction.Builder().browser(this.seleniumBrowser));
        return builder;
    }

    public StopBrowserAction.Builder stop(SeleniumBrowser seleniumBrowser) {
        StopBrowserAction.Builder builder;
        this.browser(seleniumBrowser);
        this.delegate = builder = (StopBrowserAction.Builder)((Object)new StopBrowserAction.Builder().browser(seleniumBrowser));
        return builder;
    }

    public StopBrowserAction.Builder stop(Endpoint endpoint) {
        if (endpoint instanceof SeleniumBrowser) {
            SeleniumBrowser browser = (SeleniumBrowser)endpoint;
            return this.stop(browser);
        }
        throw new CitrusRuntimeException("Invalid browser object, expected a SeleniumBrowser, but got %s".formatted(endpoint.getClass().getName()));
    }

    public AlertAction.Builder alert() {
        AlertAction.Builder builder;
        this.delegate = builder = (AlertAction.Builder)((Object)new AlertAction.Builder().browser(this.seleniumBrowser));
        return builder;
    }

    public NavigateAction.Builder navigate() {
        NavigateAction.Builder builder;
        this.delegate = builder = (NavigateAction.Builder)((Object)new NavigateAction.Builder().browser(this.seleniumBrowser));
        return builder;
    }

    public PageAction.Builder page() {
        PageAction.Builder builder;
        this.delegate = builder = (PageAction.Builder)((Object)new PageAction.Builder().browser(this.seleniumBrowser));
        return builder;
    }

    public FindElementAction.Builder find() {
        FindElementAction.Builder builder;
        this.delegate = builder = (FindElementAction.Builder)((Object)new FindElementAction.Builder().browser(this.seleniumBrowser));
        return builder;
    }

    public DropDownSelectAction.Builder select() {
        DropDownSelectAction.Builder builder;
        this.delegate = builder = (DropDownSelectAction.Builder)((Object)new DropDownSelectAction.Builder().browser(this.seleniumBrowser));
        return builder;
    }

    public SetInputAction.Builder setInput() {
        SetInputAction.Builder builder;
        this.delegate = builder = (SetInputAction.Builder)((Object)new SetInputAction.Builder().browser(this.seleniumBrowser));
        return builder;
    }

    public FillFormAction.Builder fillForm() {
        FillFormAction.Builder builder;
        this.delegate = builder = (FillFormAction.Builder)((Object)new FillFormAction.Builder().browser(this.seleniumBrowser));
        return builder;
    }

    public CheckInputAction.Builder checkInput() {
        CheckInputAction.Builder builder;
        this.delegate = builder = (CheckInputAction.Builder)((Object)new CheckInputAction.Builder().browser(this.seleniumBrowser));
        return builder;
    }

    public ClickAction.Builder click() {
        ClickAction.Builder builder;
        this.delegate = builder = (ClickAction.Builder)((Object)new ClickAction.Builder().browser(this.seleniumBrowser));
        return builder;
    }

    public HoverAction.Builder hover() {
        HoverAction.Builder builder;
        this.delegate = builder = (HoverAction.Builder)((Object)new HoverAction.Builder().browser(this.seleniumBrowser));
        return builder;
    }

    public ClearBrowserCacheAction.Builder clearCache() {
        ClearBrowserCacheAction.Builder builder;
        this.delegate = builder = (ClearBrowserCacheAction.Builder)((Object)new ClearBrowserCacheAction.Builder().browser(this.seleniumBrowser));
        return builder;
    }

    public MakeScreenshotAction.Builder screenshot() {
        MakeScreenshotAction.Builder builder;
        this.delegate = builder = (MakeScreenshotAction.Builder)((Object)new MakeScreenshotAction.Builder().browser(this.seleniumBrowser));
        return builder;
    }

    public StoreFileAction.Builder store() {
        StoreFileAction.Builder builder;
        this.delegate = builder = (StoreFileAction.Builder)((Object)new StoreFileAction.Builder().browser(this.seleniumBrowser));
        return builder;
    }

    public GetStoredFileAction.Builder getStored() {
        GetStoredFileAction.Builder builder;
        this.delegate = builder = (GetStoredFileAction.Builder)((Object)new GetStoredFileAction.Builder().browser(this.seleniumBrowser));
        return builder;
    }

    public WaitUntilAction.Builder waitUntil() {
        WaitUntilAction.Builder builder;
        this.delegate = builder = (WaitUntilAction.Builder)((Object)new WaitUntilAction.Builder().browser(this.seleniumBrowser));
        return builder;
    }

    public JavaScriptAction.Builder javascript() {
        JavaScriptAction.Builder builder;
        this.delegate = builder = (JavaScriptAction.Builder)((Object)new JavaScriptAction.Builder().browser(this.seleniumBrowser));
        return builder;
    }

    public OpenWindowAction.Builder open() {
        OpenWindowAction.Builder builder;
        this.delegate = builder = (OpenWindowAction.Builder)((Object)new OpenWindowAction.Builder().browser(this.seleniumBrowser));
        return builder;
    }

    public CloseWindowAction.Builder close() {
        CloseWindowAction.Builder builder;
        this.delegate = builder = (CloseWindowAction.Builder)((Object)new CloseWindowAction.Builder().browser(this.seleniumBrowser));
        return builder;
    }

    public SwitchWindowAction.Builder focus() {
        SwitchWindowAction.Builder builder;
        this.delegate = builder = (SwitchWindowAction.Builder)((Object)new SwitchWindowAction.Builder().browser(this.seleniumBrowser));
        return builder;
    }

    public SwitchWindowAction.Builder switchWindow() {
        SwitchWindowAction.Builder builder;
        this.delegate = builder = (SwitchWindowAction.Builder)((Object)new SwitchWindowAction.Builder().browser(this.seleniumBrowser));
        return builder;
    }

    public SeleniumAction build() {
        ObjectHelper.assertNotNull(this.delegate, (String)"Missing delegate action to build");
        if (this.seleniumBrowser != null) {
            this.delegate.browser(this.seleniumBrowser);
        }
        return (SeleniumAction)this.delegate.build();
    }

    public TestActionBuilder<?> getDelegate() {
        return this.delegate;
    }
}

