/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.selenium.actions;

import org.citrusframework.actions.selenium.SeleniumSetInputActionBuilder;
import org.citrusframework.context.TestContext;
import org.citrusframework.selenium.actions.FindElementAction;
import org.citrusframework.selenium.endpoint.SeleniumBrowser;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.Select;

public class SetInputAction
extends FindElementAction {
    private final String value;

    public SetInputAction(Builder builder) {
        super("set-input", builder);
        this.value = builder.value;
    }

    @Override
    protected void execute(WebElement webElement, SeleniumBrowser browser, TestContext context) {
        super.execute(webElement, browser, context);
        String tagName = webElement.getTagName();
        if (!"select".equalsIgnoreCase(tagName)) {
            webElement.clear();
            webElement.sendKeys(new CharSequence[]{context.replaceDynamicContentInString(this.value)});
        } else {
            new Select(webElement).selectByValue(context.replaceDynamicContentInString(this.value));
        }
    }

    public String getValue() {
        return this.value;
    }

    public static class Builder
    extends FindElementAction.ElementActionBuilder<SetInputAction, Builder>
    implements SeleniumSetInputActionBuilder<SetInputAction, Builder> {
        private String value;

        public Builder value(String value) {
            this.value = value;
            return this;
        }

        public SetInputAction build() {
            return new SetInputAction(this);
        }
    }
}

