/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.selenium.actions;

import org.citrusframework.actions.selenium.SeleniumStoreFileActionBuilder;
import org.citrusframework.context.TestContext;
import org.citrusframework.selenium.actions.AbstractSeleniumAction;
import org.citrusframework.selenium.endpoint.SeleniumBrowser;

public class StoreFileAction
extends AbstractSeleniumAction {
    private final String filePath;

    public StoreFileAction(Builder builder) {
        super("store-file", builder);
        this.filePath = builder.filePath;
    }

    @Override
    protected void execute(SeleniumBrowser browser, TestContext context) {
        browser.storeFile(context.replaceDynamicContentInString(this.filePath));
    }

    public String getFilePath() {
        return this.filePath;
    }

    public static class Builder
    extends AbstractSeleniumAction.Builder<StoreFileAction, Builder>
    implements SeleniumStoreFileActionBuilder<StoreFileAction, Builder> {
        private String filePath;

        public Builder filePath(String filePath) {
            this.filePath = filePath;
            return this;
        }

        public StoreFileAction build() {
            return new StoreFileAction(this);
        }
    }
}

