/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.selenium.actions;

import java.util.Set;
import org.citrusframework.actions.selenium.SeleniumSwitchWindowActionBuilder;
import org.citrusframework.context.TestContext;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.selenium.actions.AbstractSeleniumAction;
import org.citrusframework.selenium.actions.SeleniumAction;
import org.citrusframework.selenium.endpoint.SeleniumBrowser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SwitchWindowAction
extends AbstractSeleniumAction
implements SeleniumAction {
    private static final Logger logger = LoggerFactory.getLogger(SwitchWindowAction.class);
    private final String windowName;

    public SwitchWindowAction(Builder builder) {
        super("switch-window", builder);
        this.windowName = builder.windowName;
    }

    @Override
    protected void execute(SeleniumBrowser browser, TestContext context) {
        if (!context.getVariables().containsKey(this.windowName)) {
            throw new CitrusRuntimeException("Failed to find window handle for window " + this.windowName);
        }
        String targetWindow = context.getVariable(this.windowName);
        Set handles = browser.getWebDriver().getWindowHandles();
        if (!handles.contains(targetWindow)) {
            throw new CitrusRuntimeException("Failed to find window for handle " + context.getVariable(this.windowName));
        }
        String lastWindow = browser.getWebDriver().getWindowHandle();
        if (!lastWindow.equals(targetWindow)) {
            context.setVariable("selenium_last_window", (Object)lastWindow);
            browser.getWebDriver().switchTo().window(targetWindow);
            logger.info("Switch window focus to " + this.windowName);
            context.setVariable("selenium_active_window", (Object)targetWindow);
        } else {
            logger.info("Skip switch window action as window is already focused");
        }
    }

    public String getWindowName() {
        return this.windowName;
    }

    public static class Builder
    extends AbstractSeleniumAction.Builder<SwitchWindowAction, Builder>
    implements SeleniumSwitchWindowActionBuilder<SwitchWindowAction, Builder> {
        private String windowName = "selenium_active_window";

        public Builder window(String name) {
            this.windowName = name;
            return this;
        }

        public SwitchWindowAction build() {
            return new SwitchWindowAction(this);
        }
    }
}

