/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.selenium.endpoint;

import java.util.Map;
import org.citrusframework.context.TestContext;
import org.citrusframework.endpoint.AbstractEndpointComponent;
import org.citrusframework.endpoint.Endpoint;
import org.citrusframework.endpoint.EndpointConfiguration;
import org.citrusframework.selenium.endpoint.SeleniumBrowser;
import org.citrusframework.selenium.endpoint.SeleniumBrowserConfiguration;
import org.citrusframework.util.StringUtils;

public class SeleniumEndpointComponent
extends AbstractEndpointComponent {
    public SeleniumEndpointComponent() {
        super("selenium");
    }

    protected Endpoint createEndpoint(String resourcePath, Map<String, String> parameters, TestContext context) {
        SeleniumBrowser browser = new SeleniumBrowser();
        if (StringUtils.hasText((String)resourcePath) && !resourcePath.equals("browser")) {
            browser.getEndpointConfiguration().setBrowserType(resourcePath);
        }
        if (parameters.containsKey("start-page")) {
            browser.getEndpointConfiguration().setStartPageUrl(parameters.remove("start-page"));
        }
        if (parameters.containsKey("remote-server")) {
            browser.getEndpointConfiguration().setRemoteServerUrl(parameters.remove("remote-server"));
        }
        this.enrichEndpointConfiguration((EndpointConfiguration)browser.getEndpointConfiguration(), this.getEndpointConfigurationParameters(parameters, SeleniumBrowserConfiguration.class), context);
        return browser;
    }
}

