/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.selenium.xml;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;
import org.citrusframework.selenium.actions.FindElementAction;
import org.openqa.selenium.By;

public interface ElementAware {
    public FindElementAction.ElementActionBuilder<?, ?> getElementBuilder();

    default public void setElement(Element element) {
        if (element.getId() != null) {
            this.getElementBuilder().element(By.id((String)element.id));
        } else if (element.getName() != null) {
            this.getElementBuilder().element(By.name((String)element.name));
        } else if (element.getLinkText() != null) {
            this.getElementBuilder().element(By.linkText((String)element.linkText));
        } else if (element.getPartialLinkText() != null) {
            this.getElementBuilder().element(By.partialLinkText((String)element.partialLinkText));
        } else if (element.getXpath() != null) {
            this.getElementBuilder().element(By.xpath((String)element.xpath));
        } else if (element.getCssSelector() != null) {
            this.getElementBuilder().element(By.cssSelector((String)element.cssSelector));
        } else if (element.getProperty() != null) {
            this.getElementBuilder().element(element.getProperty().getName(), element.getProperty().getValue());
        } else if (element.getClassName() != null) {
            this.getElementBuilder().element(By.className((String)element.className));
        } else if (element.getTagName() != null) {
            this.getElementBuilder().element(By.tagName((String)element.tagName));
        }
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    @XmlType(name="", propOrder={})
    public static class Element {
        @XmlAttribute
        private String id;
        @XmlAttribute
        private String name;
        @XmlAttribute(name="tag-name")
        private String tagName;
        @XmlAttribute(name="class-name")
        private String className;
        @XmlElement
        private Property property;
        @XmlAttribute(name="link-text")
        private String linkText;
        @XmlAttribute(name="partial-link-text")
        private String partialLinkText;
        @XmlAttribute(name="xpath")
        private String xpath;
        @XmlAttribute(name="css-selector")
        private String cssSelector;

        public void setId(String id) {
            this.id = id;
        }

        public String getId() {
            return this.id;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public String getTagName() {
            return this.tagName;
        }

        public void setTagName(String tagName) {
            this.tagName = tagName;
        }

        public String getClassName() {
            return this.className;
        }

        public void setClassName(String className) {
            this.className = className;
        }

        public void setLinkText(String linkText) {
            this.linkText = linkText;
        }

        public String getLinkText() {
            return this.linkText;
        }

        public void setPartialLinkText(String partialLinkText) {
            this.partialLinkText = partialLinkText;
        }

        public String getPartialLinkText() {
            return this.partialLinkText;
        }

        public void setXpath(String xpath) {
            this.xpath = xpath;
        }

        public String getXpath() {
            return this.xpath;
        }

        public void setCssSelector(String cssSelector) {
            this.cssSelector = cssSelector;
        }

        public String getCssSelector() {
            return this.cssSelector;
        }

        public void setProperty(Property property) {
            this.property = property;
        }

        public Property getProperty() {
            return this.property;
        }

        @XmlAccessorType(value=XmlAccessType.FIELD)
        @XmlType(name="", propOrder={})
        public static class Property {
            @XmlAttribute
            private String name;
            @XmlAttribute
            private String value;

            public void setName(String name) {
                this.name = name;
            }

            public String getName() {
                return this.name;
            }

            public void setValue(String value) {
                this.value = value;
            }

            public String getValue() {
                return this.value;
            }
        }
    }
}

