/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.selenium.xml;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.citrusframework.TestActor;
import org.citrusframework.selenium.actions.AbstractSeleniumAction;
import org.citrusframework.selenium.actions.FillFormAction;
import org.citrusframework.selenium.endpoint.SeleniumBrowser;

@XmlRootElement(name="fill-form")
public class FillForm
extends AbstractSeleniumAction.Builder<FillFormAction, FillForm> {
    private final FillFormAction.Builder delegate = new FillFormAction.Builder();

    @XmlElement(name="fields")
    public void setFields(Fields fields) {
        this.delegate.fields((Map)fields.getFields().stream().collect(Collectors.toMap(Fields.Field::getId, Fields.Field::getValue)));
    }

    @XmlElement(name="json")
    public void setJson(String json) {
        this.delegate.fromJson(json);
    }

    @XmlAttribute
    public void setSubmit(String value) {
        this.delegate.submit(value);
    }

    public FillForm description(String description) {
        this.delegate.description(description);
        return this;
    }

    public FillForm actor(TestActor actor) {
        this.delegate.actor(actor);
        return this;
    }

    @Override
    public FillForm browser(SeleniumBrowser seleniumBrowser) {
        this.delegate.browser(seleniumBrowser);
        return this;
    }

    public FillFormAction build() {
        return this.delegate.build();
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    @XmlType(name="", propOrder={"fields"})
    public static class Fields {
        @XmlElement(name="field")
        private List<Field> fields;

        public void setFields(List<Field> fields) {
            this.fields = fields;
        }

        public List<Field> getFields() {
            if (this.fields == null) {
                this.fields = new ArrayList<Field>();
            }
            return this.fields;
        }

        @XmlAccessorType(value=XmlAccessType.FIELD)
        @XmlType(name="", propOrder={})
        public static class Field {
            @XmlAttribute
            private String id;
            @XmlAttribute
            private String value;
            @XmlElement(name="value")
            private String valueData;

            public void setId(String id) {
                this.id = id;
            }

            public String getId() {
                return this.id;
            }

            public void setValue(String value) {
                this.value = value;
            }

            public String getValue() {
                if (this.value == null) {
                    return this.getValueData();
                }
                return this.value;
            }

            public String getValueData() {
                return this.valueData;
            }

            public void setValueData(String valueData) {
                this.valueData = valueData;
            }
        }
    }
}

