/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.selenium.xml;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import java.util.ArrayList;
import java.util.List;
import org.citrusframework.TestActor;
import org.citrusframework.selenium.actions.AbstractSeleniumAction;
import org.citrusframework.selenium.actions.FindElementAction;
import org.citrusframework.selenium.endpoint.SeleniumBrowser;
import org.citrusframework.selenium.xml.ElementAware;

@XmlRootElement(name="find")
public class FindElement
extends AbstractSeleniumAction.Builder<FindElementAction, FindElement>
implements ElementAware {
    private final FindElementAction.Builder delegate = new FindElementAction.Builder();

    @Override
    @XmlElement
    public void setElement(ElementAware.Element element) {
        ElementAware.super.setElement(element);
    }

    @XmlElement
    public void setValidate(Validate validate) {
        if (validate.getText() != null) {
            this.delegate.text(validate.text);
        }
        if (validate.getTagName() != null) {
            this.delegate.tagName(validate.tagName);
        }
        this.delegate.enabled(validate.enabled);
        this.delegate.displayed(validate.displayed);
        if (validate.getAttributes() != null) {
            for (Attributes.Attribute attribute : validate.getAttributes().attributes) {
                this.delegate.attribute(attribute.getName(), attribute.getValue());
            }
        }
        if (validate.getStyles() != null) {
            for (Styles.Style style : validate.getStyles().styles) {
                this.delegate.style(style.getName(), style.getValue());
            }
        }
    }

    @Override
    public FindElementAction.ElementActionBuilder<?, ?> getElementBuilder() {
        return this.delegate;
    }

    public FindElement description(String description) {
        this.delegate.description(description);
        return this;
    }

    public FindElement actor(TestActor actor) {
        this.delegate.actor(actor);
        return this;
    }

    @Override
    public FindElement browser(SeleniumBrowser seleniumBrowser) {
        this.delegate.browser(seleniumBrowser);
        return this;
    }

    public FindElementAction build() {
        return this.delegate.build();
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    @XmlType(name="", propOrder={"attributes", "styles"})
    public static class Validate {
        @XmlAttribute
        private String text;
        @XmlAttribute(name="tag-name")
        private String tagName;
        @XmlAttribute
        private boolean displayed = true;
        @XmlAttribute
        private boolean enabled = true;
        @XmlElement
        private Attributes attributes;
        @XmlElement
        private Styles styles;

        public String getText() {
            return this.text;
        }

        public void setText(String text) {
            this.text = text;
        }

        public String getTagName() {
            return this.tagName;
        }

        public void setTagName(String tagName) {
            this.tagName = tagName;
        }

        public Attributes getAttributes() {
            return this.attributes;
        }

        public void setAttributes(Attributes attributes) {
            this.attributes = attributes;
        }

        public Styles getStyles() {
            return this.styles;
        }

        public void setStyles(Styles styles) {
            this.styles = styles;
        }

        public boolean isDisplayed() {
            return this.displayed;
        }

        public void setDisplayed(boolean displayed) {
            this.displayed = displayed;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    @XmlType(name="", propOrder={"attributes"})
    public static class Attributes {
        @XmlElement(name="attribute")
        private List<Attribute> attributes;

        public List<Attribute> getAttributes() {
            if (this.attributes == null) {
                this.attributes = new ArrayList<Attribute>();
            }
            return this.attributes;
        }

        public void setAttributes(List<Attribute> attributes) {
            this.attributes = attributes;
        }

        @XmlAccessorType(value=XmlAccessType.FIELD)
        @XmlType(name="", propOrder={})
        public static class Attribute {
            @XmlAttribute
            private String name;
            @XmlAttribute
            private String value;

            public void setName(String name) {
                this.name = name;
            }

            public String getName() {
                return this.name;
            }

            public void setValue(String value) {
                this.value = value;
            }

            public String getValue() {
                return this.value;
            }
        }
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    @XmlType(name="", propOrder={"styles"})
    public static class Styles {
        @XmlElement(name="style")
        private List<Style> styles;

        public List<Style> getStyles() {
            if (this.styles == null) {
                this.styles = new ArrayList<Style>();
            }
            return this.styles;
        }

        public void setStyles(List<Style> styles) {
            this.styles = styles;
        }

        @XmlAccessorType(value=XmlAccessType.FIELD)
        @XmlType(name="", propOrder={})
        public static class Style {
            @XmlAttribute
            private String name;
            @XmlAttribute
            private String value;

            public void setName(String name) {
                this.name = name;
            }

            public String getName() {
                return this.name;
            }

            public void setValue(String value) {
                this.value = value;
            }

            public String getValue() {
                return this.value;
            }
        }
    }
}

