/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.channel;

import org.citrusframework.channel.ChannelEndpoint;
import org.citrusframework.channel.ChannelSyncEndpoint;
import org.citrusframework.channel.ChannelSyncEndpointConfiguration;
import org.citrusframework.channel.ChannelSyncProducer;
import org.citrusframework.context.TestContext;
import org.citrusframework.endpoint.AbstractEndpointAdapter;
import org.citrusframework.exceptions.ActionTimeoutException;
import org.citrusframework.message.Message;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;

public class ChannelEndpointAdapter
extends AbstractEndpointAdapter {
    private final ChannelSyncEndpoint endpoint;
    private final ChannelSyncProducer producer;
    private final ChannelSyncEndpointConfiguration endpointConfiguration;
    private static final Logger LOG = LoggerFactory.getLogger(ChannelEndpointAdapter.class);

    public ChannelEndpointAdapter(ChannelSyncEndpointConfiguration endpointConfiguration) {
        this.endpointConfiguration = endpointConfiguration;
        this.endpointConfiguration.setFilterInternalHeaders(false);
        this.endpoint = new ChannelSyncEndpoint(endpointConfiguration);
        this.endpoint.setName(this.getName());
        this.producer = new ChannelSyncProducer(this.endpoint.getProducerName(), endpointConfiguration);
    }

    public Message handleMessageInternal(Message request) {
        LOG.debug("Forwarding request to message channel ...");
        TestContext context = this.getTestContext();
        Message replyMessage = null;
        try {
            this.producer.send(request, context);
            replyMessage = this.endpointConfiguration.getCorrelator() != null ? this.producer.receive(this.endpointConfiguration.getCorrelator().getCorrelationKey(request), context, this.endpointConfiguration.getTimeout()) : this.producer.receive(context, this.endpointConfiguration.getTimeout());
        }
        catch (ActionTimeoutException e) {
            LOG.warn(e.getMessage());
        }
        return replyMessage;
    }

    public ChannelEndpoint getEndpoint() {
        return this.endpoint;
    }

    public ChannelSyncEndpointConfiguration getEndpointConfiguration() {
        return this.endpointConfiguration;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.endpointConfiguration.setBeanFactory(beanFactory);
    }
}

