/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.channel;

import org.citrusframework.channel.ChannelConsumer;
import org.citrusframework.channel.ChannelSyncEndpointConfiguration;
import org.citrusframework.context.TestContext;
import org.citrusframework.endpoint.PollableEndpointConfiguration;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.message.Message;
import org.citrusframework.message.correlation.CorrelationManager;
import org.citrusframework.message.correlation.PollingCorrelationManager;
import org.citrusframework.messaging.ReplyProducer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.MessageDeliveryException;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class ChannelSyncConsumer
extends ChannelConsumer
implements ReplyProducer {
    private static Logger log = LoggerFactory.getLogger(ChannelSyncConsumer.class);
    private CorrelationManager<MessageChannel> correlationManager;
    private final ChannelSyncEndpointConfiguration endpointConfiguration;

    public ChannelSyncConsumer(String name, ChannelSyncEndpointConfiguration endpointConfiguration) {
        super(name, endpointConfiguration);
        this.endpointConfiguration = endpointConfiguration;
        this.correlationManager = new PollingCorrelationManager((PollableEndpointConfiguration)endpointConfiguration, "Reply channel not set up yet");
    }

    @Override
    public Message receive(String selector, TestContext context, long timeout) {
        Message receivedMessage = super.receive(selector, context, timeout);
        this.saveReplyMessageChannel(receivedMessage, context);
        return receivedMessage;
    }

    public void send(Message message, TestContext context) {
        Assert.notNull((Object)message, (String)"Can not send empty message");
        String correlationKeyName = this.endpointConfiguration.getCorrelator().getCorrelationKeyName(this.getName());
        String correlationKey = this.correlationManager.getCorrelationKey(correlationKeyName, context);
        MessageChannel replyChannel = (MessageChannel)this.correlationManager.find(correlationKey, this.endpointConfiguration.getTimeout());
        Assert.notNull((Object)replyChannel, (String)("Failed to find reply channel for message correlation key: " + correlationKey));
        if (log.isDebugEnabled()) {
            log.debug("Sending message to reply channel: '" + replyChannel + "'");
            log.debug("Message to send is:\n" + message.toString());
        }
        try {
            this.endpointConfiguration.getMessagingTemplate().send((Object)replyChannel, this.endpointConfiguration.getMessageConverter().convertOutbound(message, this.endpointConfiguration, context));
        }
        catch (MessageDeliveryException e) {
            throw new CitrusRuntimeException("Failed to send message to channel: '" + replyChannel + "'", (Throwable)e);
        }
        log.info("Message was sent to reply channel: '" + replyChannel + "'");
    }

    public void saveReplyMessageChannel(Message receivedMessage, TestContext context) {
        MessageChannel replyChannel = null;
        if (receivedMessage.getHeader("replyChannel") instanceof MessageChannel) {
            replyChannel = (MessageChannel)receivedMessage.getHeader("replyChannel");
        } else if (StringUtils.hasText((String)((String)receivedMessage.getHeader("replyChannel")))) {
            replyChannel = this.resolveChannelName(receivedMessage.getHeader("replyChannel").toString(), context);
        }
        if (replyChannel != null) {
            String correlationKeyName = this.endpointConfiguration.getCorrelator().getCorrelationKeyName(this.getName());
            String correlationKey = this.endpointConfiguration.getCorrelator().getCorrelationKey(receivedMessage);
            this.correlationManager.saveCorrelationKey(correlationKeyName, correlationKey, context);
            this.correlationManager.store(correlationKey, (Object)replyChannel);
        } else {
            log.warn("Unable to retrieve reply message channel for message \n" + receivedMessage + "\n - no reply channel found in message headers!");
        }
    }

    public CorrelationManager<MessageChannel> getCorrelationManager() {
        return this.correlationManager;
    }

    public void setCorrelationManager(CorrelationManager<MessageChannel> correlationManager) {
        this.correlationManager = correlationManager;
    }
}

