/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.channel;

import org.citrusframework.channel.ChannelProducer;
import org.citrusframework.channel.ChannelSyncEndpointConfiguration;
import org.citrusframework.context.TestContext;
import org.citrusframework.endpoint.PollableEndpointConfiguration;
import org.citrusframework.exceptions.MessageTimeoutException;
import org.citrusframework.exceptions.ReplyMessageTimeoutException;
import org.citrusframework.message.Message;
import org.citrusframework.message.correlation.CorrelationManager;
import org.citrusframework.message.correlation.PollingCorrelationManager;
import org.citrusframework.messaging.ReplyConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChannelSyncProducer
extends ChannelProducer
implements ReplyConsumer {
    private static Logger log = LoggerFactory.getLogger(ChannelSyncProducer.class);
    private CorrelationManager<Message> correlationManager;
    private final ChannelSyncEndpointConfiguration endpointConfiguration;

    public ChannelSyncProducer(String name, ChannelSyncEndpointConfiguration endpointConfiguration) {
        super(name, endpointConfiguration);
        this.endpointConfiguration = endpointConfiguration;
        this.correlationManager = new PollingCorrelationManager((PollableEndpointConfiguration)endpointConfiguration, "Reply message did not arrive yet");
    }

    @Override
    public void send(Message message, TestContext context) {
        String correlationKeyName = this.endpointConfiguration.getCorrelator().getCorrelationKeyName(this.getName());
        String correlationKey = this.endpointConfiguration.getCorrelator().getCorrelationKey(message);
        this.correlationManager.saveCorrelationKey(correlationKeyName, correlationKey, context);
        String destinationChannelName = this.getDestinationChannelName();
        if (log.isDebugEnabled()) {
            log.debug("Sending message to channel: '" + destinationChannelName + "'");
            log.debug("Message to send is:\n" + message.toString());
        }
        this.endpointConfiguration.getMessagingTemplate().setReceiveTimeout(this.endpointConfiguration.getTimeout());
        log.info("Message was sent to channel: '" + destinationChannelName + "'");
        org.springframework.messaging.Message replyMessage = this.endpointConfiguration.getMessagingTemplate().sendAndReceive(this.getDestinationChannel(context), this.endpointConfiguration.getMessageConverter().convertOutbound(message, this.endpointConfiguration, context));
        if (replyMessage == null) {
            throw new ReplyMessageTimeoutException(this.endpointConfiguration.getTimeout(), destinationChannelName);
        }
        log.info("Received synchronous response from reply channel '" + destinationChannelName + "'");
        this.correlationManager.store(correlationKey, (Object)this.endpointConfiguration.getMessageConverter().convertInbound(replyMessage, this.endpointConfiguration, context));
    }

    public Message receive(TestContext context) {
        return this.receive(this.correlationManager.getCorrelationKey(this.endpointConfiguration.getCorrelator().getCorrelationKeyName(this.getName()), context), context);
    }

    public Message receive(String selector, TestContext context) {
        return this.receive(selector, context, this.endpointConfiguration.getTimeout());
    }

    public Message receive(TestContext context, long timeout) {
        return this.receive(this.correlationManager.getCorrelationKey(this.endpointConfiguration.getCorrelator().getCorrelationKeyName(this.getName()), context), context, timeout);
    }

    public Message receive(String selector, TestContext context, long timeout) {
        Message message = (Message)this.correlationManager.find(selector, timeout);
        if (message == null) {
            throw new MessageTimeoutException(timeout, this.getDestinationChannelName());
        }
        return message;
    }

    public CorrelationManager<Message> getCorrelationManager() {
        return this.correlationManager;
    }

    public void setCorrelationManager(CorrelationManager<Message> correlationManager) {
        this.correlationManager = correlationManager;
    }
}

