/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.channel.selector;

import javax.xml.namespace.QName;
import org.citrusframework.channel.selector.AbstractMessageSelector;
import org.citrusframework.channel.selector.MessageSelectorFactory;
import org.citrusframework.context.TestContext;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.util.XMLUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.messaging.Message;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.xml.namespace.QNameUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.ls.LSException;

public class RootQNameMessageSelector
extends AbstractMessageSelector {
    private QName rootQName;
    public static final String SELECTOR_ID = "root-qname";
    private static Logger log = LoggerFactory.getLogger(RootQNameMessageSelector.class);

    public RootQNameMessageSelector(String name, String value, TestContext context) {
        super(name, value, context);
        Assert.isTrue((boolean)this.selectKey.equals(SELECTOR_ID), (String)String.format("Invalid usage of root QName message selector - usage restricted to key '%s' but was '%s'", SELECTOR_ID, this.selectKey));
        if (!QNameUtils.validateQName((String)value)) {
            throw new CitrusRuntimeException("Invalid root QName string '" + value + "'");
        }
        this.rootQName = QNameUtils.parseQNameString((String)value);
    }

    public boolean accept(Message<?> message) {
        Document doc;
        try {
            doc = XMLUtils.parseMessagePayload((String)this.getPayloadAsString(message));
        }
        catch (LSException e) {
            log.warn("Root QName message selector ignoring not well-formed XML message payload", (Throwable)e);
            return false;
        }
        if (StringUtils.hasText((String)this.rootQName.getNamespaceURI())) {
            return this.rootQName.equals(QNameUtils.getQNameForNode((Node)doc.getFirstChild()));
        }
        return this.rootQName.getLocalPart().equals(doc.getFirstChild().getLocalName());
    }

    public static class Factory
    implements MessageSelectorFactory<RootQNameMessageSelector> {
        @Override
        public boolean supports(String key) {
            return key.equals(RootQNameMessageSelector.SELECTOR_ID);
        }

        @Override
        public RootQNameMessageSelector create(String key, String value, TestContext context) {
            return new RootQNameMessageSelector(key, value, context);
        }
    }
}

