/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.channel;

import org.citrusframework.channel.ChannelEndpoint;
import org.citrusframework.channel.ChannelMessageConverter;
import org.citrusframework.endpoint.AbstractEndpointBuilder;
import org.springframework.integration.core.MessagingTemplate;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.core.DestinationResolver;

public class ChannelEndpointBuilder
extends AbstractEndpointBuilder<ChannelEndpoint> {
    private ChannelEndpoint endpoint = new ChannelEndpoint();

    protected ChannelEndpoint getEndpoint() {
        return this.endpoint;
    }

    public ChannelEndpointBuilder channel(String channelName) {
        this.endpoint.getEndpointConfiguration().setChannelName(channelName);
        return this;
    }

    public ChannelEndpointBuilder channel(MessageChannel channel) {
        this.endpoint.getEndpointConfiguration().setChannel(channel);
        return this;
    }

    public ChannelEndpointBuilder messagingTemplate(MessagingTemplate messagingTemplate) {
        this.endpoint.getEndpointConfiguration().setMessagingTemplate(messagingTemplate);
        return this;
    }

    public ChannelEndpointBuilder messageConverter(ChannelMessageConverter messageConverter) {
        this.endpoint.getEndpointConfiguration().setMessageConverter(messageConverter);
        return this;
    }

    public ChannelEndpointBuilder channelResolver(DestinationResolver resolver) {
        this.endpoint.getEndpointConfiguration().setChannelResolver((DestinationResolver<MessageChannel>)resolver);
        return this;
    }

    public ChannelEndpointBuilder useObjectMessages(boolean useObjectMessages) {
        this.endpoint.getEndpointConfiguration().setUseObjectMessages(useObjectMessages);
        return this;
    }

    public ChannelEndpointBuilder filterInternalHeaders(boolean filterInternalHeaders) {
        this.endpoint.getEndpointConfiguration().setFilterInternalHeaders(filterInternalHeaders);
        return this;
    }

    public ChannelEndpointBuilder timeout(long timeout) {
        this.endpoint.getEndpointConfiguration().setTimeout(timeout);
        return this;
    }
}

