/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.channel;

import java.util.Map;
import org.citrusframework.channel.ChannelEndpoint;
import org.citrusframework.channel.ChannelSyncEndpoint;
import org.citrusframework.channel.ChannelSyncEndpointConfiguration;
import org.citrusframework.context.TestContext;
import org.citrusframework.endpoint.AbstractEndpointComponent;
import org.citrusframework.endpoint.Endpoint;
import org.citrusframework.endpoint.EndpointConfiguration;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.core.DestinationResolver;

public class ChannelEndpointComponent
extends AbstractEndpointComponent {
    public ChannelEndpointComponent() {
        super("channel");
    }

    protected Endpoint createEndpoint(String resourcePath, Map<String, String> parameters, TestContext context) {
        ChannelEndpoint endpoint;
        if (resourcePath.startsWith("sync:")) {
            ChannelSyncEndpointConfiguration endpointConfiguration = new ChannelSyncEndpointConfiguration();
            endpoint = new ChannelSyncEndpoint(endpointConfiguration);
            endpoint.getEndpointConfiguration().setChannelName(resourcePath.substring("sync:".length()));
        } else {
            endpoint = new ChannelEndpoint();
            endpoint.getEndpointConfiguration().setChannelName(resourcePath);
        }
        if (context.getReferenceResolver() != null) {
            endpoint.getEndpointConfiguration().setChannelResolver((DestinationResolver<MessageChannel>)((DestinationResolver)channelName -> (MessageChannel)context.getReferenceResolver().resolve(channelName, MessageChannel.class)));
        }
        this.enrichEndpointConfiguration((EndpointConfiguration)endpoint.getEndpointConfiguration(), parameters, context);
        return endpoint;
    }
}

