/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.channel.selector;

import org.citrusframework.channel.selector.AbstractMessageSelector;
import org.citrusframework.channel.selector.MessageSelectorFactory;
import org.citrusframework.context.TestContext;
import org.springframework.messaging.Message;
import org.springframework.util.Assert;

public class PayloadMatchingMessageSelector
extends AbstractMessageSelector {
    public static final String SELECTOR_ID = "payload";

    public PayloadMatchingMessageSelector(String selectKey, String matchingValue, TestContext context) {
        super(selectKey, matchingValue, context);
        Assert.isTrue((boolean)selectKey.equals(SELECTOR_ID), (String)String.format("Invalid usage of payload matching message selector - usage restricted to key '%s' but was '%s'", SELECTOR_ID, selectKey));
    }

    public boolean accept(Message<?> message) {
        return this.evaluate(this.getPayloadAsString(message));
    }

    public static class Factory
    implements MessageSelectorFactory<PayloadMatchingMessageSelector> {
        @Override
        public boolean supports(String key) {
            return key.equals(PayloadMatchingMessageSelector.SELECTOR_ID);
        }

        @Override
        public PayloadMatchingMessageSelector create(String key, String value, TestContext context) {
            return new PayloadMatchingMessageSelector(key, value, context);
        }
    }
}

