/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.channel.selector;

import org.citrusframework.context.TestContext;
import org.citrusframework.exceptions.ValidationException;
import org.citrusframework.message.Message;
import org.citrusframework.validation.matcher.ValidationMatcherUtils;
import org.springframework.integration.core.MessageSelector;

public abstract class AbstractMessageSelector
implements MessageSelector {
    protected final String selectKey;
    protected final String matchingValue;
    protected final TestContext context;

    public AbstractMessageSelector(String selectKey, String matchingValue, TestContext context) {
        this.selectKey = selectKey;
        this.matchingValue = matchingValue;
        this.context = context;
    }

    String getPayloadAsString(org.springframework.messaging.Message<?> message) {
        if (message.getPayload() instanceof Message) {
            return (String)((Message)message.getPayload()).getPayload(String.class);
        }
        return message.getPayload().toString();
    }

    protected boolean evaluate(String value) {
        if (ValidationMatcherUtils.isValidationMatcherExpression((String)this.matchingValue)) {
            try {
                ValidationMatcherUtils.resolveValidationMatcher((String)this.selectKey, (String)value, (String)this.matchingValue, (TestContext)this.context);
                return true;
            }
            catch (ValidationException e) {
                return false;
            }
        }
        return value.equals(this.matchingValue);
    }
}

