/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.springintegration.xml;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlTransient;
import jakarta.xml.bind.annotation.XmlType;
import java.util.ArrayList;
import java.util.List;
import org.citrusframework.TestAction;
import org.citrusframework.TestActionBuilder;
import org.citrusframework.TestActor;
import org.citrusframework.actions.PurgeMessageChannelAction;
import org.citrusframework.context.SpringBeanReferenceResolver;
import org.citrusframework.spi.ReferenceResolver;
import org.citrusframework.spi.ReferenceResolverAware;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.integration.core.MessageSelector;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.core.DestinationResolver;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="", propOrder={"description", "channels"})
@XmlRootElement(name="purge-channels")
public class PurgeChannels
implements TestActionBuilder<TestAction>,
ReferenceResolverAware {
    @XmlTransient
    private final PurgeMessageChannelAction.Builder builder = new PurgeMessageChannelAction.Builder();
    @XmlElement
    private String description;
    @XmlAttribute
    private String actor;
    @XmlAttribute(name="channel-resolver")
    protected String channelResolver;
    @XmlAttribute(name="message-selector")
    protected String messageSelector;
    @XmlElement(name="channel")
    protected List<Channel> channels;
    @XmlTransient
    private ReferenceResolver referenceResolver;

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public void setActor(String actor) {
        this.actor = actor;
    }

    public String getActor() {
        return this.actor;
    }

    public void setChannelResolver(String channelResolver) {
        this.channelResolver = channelResolver;
    }

    public String getChannelResolver() {
        return this.channelResolver;
    }

    public void setMessageSelector(String messageSelector) {
        this.messageSelector = messageSelector;
    }

    public String getMessageSelector() {
        return this.messageSelector;
    }

    public void setChannels(List<Channel> channels) {
        this.channels = channels;
    }

    public List<Channel> getChannels() {
        if (this.channels == null) {
            this.channels = new ArrayList<Channel>();
        }
        return this.channels;
    }

    public TestAction build() {
        this.builder.setReferenceResolver(this.referenceResolver);
        this.builder.description(this.description);
        for (Channel channel : this.getChannels()) {
            if (channel.name != null) {
                this.builder.channel(channel.getName());
            }
            if (channel.ref == null || this.referenceResolver == null) continue;
            this.builder.channel((MessageChannel)this.referenceResolver.resolve(channel.ref, MessageChannel.class));
        }
        if (this.referenceResolver != null) {
            if (this.referenceResolver instanceof SpringBeanReferenceResolver) {
                this.builder.beanFactory((BeanFactory)((SpringBeanReferenceResolver)this.referenceResolver).getApplicationContext());
                this.builder.withApplicationContext(((SpringBeanReferenceResolver)this.referenceResolver).getApplicationContext());
            }
            if (this.actor != null) {
                this.builder.actor((TestActor)this.referenceResolver.resolve(this.actor, TestActor.class));
            }
            if (this.channelResolver != null) {
                this.builder.channelResolver((DestinationResolver<MessageChannel>)((DestinationResolver)this.referenceResolver.resolve(this.channelResolver, DestinationResolver.class)));
            } else {
                this.builder.channelResolver(this.referenceResolver);
            }
            if (this.messageSelector != null) {
                this.builder.selector((MessageSelector)this.referenceResolver.resolve(this.messageSelector, MessageSelector.class));
            }
        }
        return this.builder.build();
    }

    public void setReferenceResolver(ReferenceResolver referenceResolver) {
        this.referenceResolver = referenceResolver;
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    @XmlType(name="", propOrder={})
    public static class Channel {
        @XmlAttribute
        protected String name;
        @XmlAttribute
        protected String ref;

        public void setName(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public void setRef(String ref) {
            this.ref = ref;
        }

        public String getRef() {
            return this.ref;
        }
    }
}

