/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.config;

import java.util.HashMap;
import java.util.Map;
import org.citrusframework.config.xml.ActionParser;
import org.citrusframework.config.xml.AntRunActionParser;
import org.citrusframework.config.xml.AssertParser;
import org.citrusframework.config.xml.AsyncParser;
import org.citrusframework.config.xml.CallTemplateParser;
import org.citrusframework.config.xml.CatchParser;
import org.citrusframework.config.xml.ConditionalParser;
import org.citrusframework.config.xml.CreateVariablesActionParser;
import org.citrusframework.config.xml.DelayActionParser;
import org.citrusframework.config.xml.EchoActionParser;
import org.citrusframework.config.xml.FailActionParser;
import org.citrusframework.config.xml.InputActionParser;
import org.citrusframework.config.xml.IterateParser;
import org.citrusframework.config.xml.JavaActionParser;
import org.citrusframework.config.xml.LoadPropertiesActionParser;
import org.citrusframework.config.xml.ParallelParser;
import org.citrusframework.config.xml.PrintActionParser;
import org.citrusframework.config.xml.PurgeEndpointActionParser;
import org.citrusframework.config.xml.ReceiveMessageActionParser;
import org.citrusframework.config.xml.ReceiveTimeoutActionParser;
import org.citrusframework.config.xml.RepeatOnErrorUntilTrueParser;
import org.citrusframework.config.xml.RepeatUntilTrueParser;
import org.citrusframework.config.xml.SendMessageActionParser;
import org.citrusframework.config.xml.SequenceParser;
import org.citrusframework.config.xml.SleepActionParser;
import org.citrusframework.config.xml.StartServerActionParser;
import org.citrusframework.config.xml.StopServerActionParser;
import org.citrusframework.config.xml.StopTimeActionParser;
import org.citrusframework.config.xml.StopTimerParser;
import org.citrusframework.config.xml.TemplateParser;
import org.citrusframework.config.xml.TestCaseMetaInfoParser;
import org.citrusframework.config.xml.TestCaseParser;
import org.citrusframework.config.xml.TimerParser;
import org.citrusframework.config.xml.TraceVariablesActionParser;
import org.citrusframework.config.xml.TransformActionParser;
import org.citrusframework.config.xml.WaitParser;
import org.citrusframework.spi.ResourcePathTypeResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.xml.BeanDefinitionParser;

public final class CitrusNamespaceParserRegistry {
    private static final Logger LOG = LoggerFactory.getLogger(CitrusNamespaceParserRegistry.class);
    private static final String RESOURCE_PATH = "META-INF/citrus/action/parser";
    private static final ResourcePathTypeResolver TYPE_RESOLVER = new ResourcePathTypeResolver("META-INF/citrus/action/parser");
    private static final Map<String, BeanDefinitionParser> BEAN_PARSER = new HashMap<String, BeanDefinitionParser>();

    private CitrusNamespaceParserRegistry() {
    }

    public static void registerParser(String beanName, BeanDefinitionParser parserObject) {
        BEAN_PARSER.put(beanName, parserObject);
    }

    public static Map<String, BeanDefinitionParser> getRegisteredBeanParser() {
        return BEAN_PARSER;
    }

    public static BeanDefinitionParser getBeanParser(String name) {
        if (!BEAN_PARSER.containsKey(name)) {
            try {
                BEAN_PARSER.put(name, (BeanDefinitionParser)TYPE_RESOLVER.resolve(name, new Object[0]));
            }
            catch (Exception e) {
                LOG.warn(String.format("Unable to locate bean parser for '%s'", name), (Throwable)e);
            }
        }
        return BEAN_PARSER.get(name);
    }

    public static Map<String, BeanDefinitionParser> lookupBeanParser() {
        return TYPE_RESOLVER.resolveAll();
    }

    static {
        CitrusNamespaceParserRegistry.registerParser("testcase", new TestCaseParser());
        CitrusNamespaceParserRegistry.registerParser("meta-info", new TestCaseMetaInfoParser());
        CitrusNamespaceParserRegistry.registerParser("template", new TemplateParser());
        CitrusNamespaceParserRegistry.registerParser("send", new SendMessageActionParser());
        CitrusNamespaceParserRegistry.registerParser("receive", new ReceiveMessageActionParser());
        CitrusNamespaceParserRegistry.registerParser("java", new JavaActionParser());
        CitrusNamespaceParserRegistry.registerParser("sleep", new SleepActionParser());
        CitrusNamespaceParserRegistry.registerParser("delay", new DelayActionParser());
        CitrusNamespaceParserRegistry.registerParser("trace-variables", new TraceVariablesActionParser());
        CitrusNamespaceParserRegistry.registerParser("create-variables", new CreateVariablesActionParser());
        CitrusNamespaceParserRegistry.registerParser("trace-time", new StopTimeActionParser());
        CitrusNamespaceParserRegistry.registerParser("echo", new EchoActionParser());
        CitrusNamespaceParserRegistry.registerParser("print", new PrintActionParser());
        CitrusNamespaceParserRegistry.registerParser("expect-timeout", new ReceiveTimeoutActionParser());
        CitrusNamespaceParserRegistry.registerParser("purge-endpoint", new PurgeEndpointActionParser());
        CitrusNamespaceParserRegistry.registerParser("action", new ActionParser());
        CitrusNamespaceParserRegistry.registerParser("template", new TemplateParser());
        CitrusNamespaceParserRegistry.registerParser("call-template", new CallTemplateParser());
        CitrusNamespaceParserRegistry.registerParser("conditional", new ConditionalParser());
        CitrusNamespaceParserRegistry.registerParser("sequential", new SequenceParser());
        CitrusNamespaceParserRegistry.registerParser("async", new AsyncParser());
        CitrusNamespaceParserRegistry.registerParser("iterate", new IterateParser());
        CitrusNamespaceParserRegistry.registerParser("repeat-until-true", new RepeatUntilTrueParser());
        CitrusNamespaceParserRegistry.registerParser("repeat-onerror-until-true", new RepeatOnErrorUntilTrueParser());
        CitrusNamespaceParserRegistry.registerParser("fail", new FailActionParser());
        CitrusNamespaceParserRegistry.registerParser("input", new InputActionParser());
        CitrusNamespaceParserRegistry.registerParser("load", new LoadPropertiesActionParser());
        CitrusNamespaceParserRegistry.registerParser("parallel", new ParallelParser());
        CitrusNamespaceParserRegistry.registerParser("catch", new CatchParser());
        CitrusNamespaceParserRegistry.registerParser("assert", new AssertParser());
        CitrusNamespaceParserRegistry.registerParser("transform", new TransformActionParser());
        CitrusNamespaceParserRegistry.registerParser("ant", new AntRunActionParser());
        CitrusNamespaceParserRegistry.registerParser("start", new StartServerActionParser());
        CitrusNamespaceParserRegistry.registerParser("stop", new StopServerActionParser());
        CitrusNamespaceParserRegistry.registerParser("wait", new WaitParser());
        CitrusNamespaceParserRegistry.registerParser("timer", new TimerParser());
        CitrusNamespaceParserRegistry.registerParser("stop-timer", new StopTimerParser());
        CitrusNamespaceParserRegistry.registerParser("stop-timer", new StopTimerParser());
    }
}

