/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.config;

import java.util.List;
import org.citrusframework.TestAction;
import org.citrusframework.TestCase;
import org.springframework.beans.factory.FactoryBean;

public class TestCaseFactory
implements FactoryBean<TestCase> {
    private TestCase testCase;
    private List<TestAction> testActions;
    private List<TestAction> finalActions;

    public TestCase getObject() throws Exception {
        if (this.testActions != null && this.testActions.size() > 0) {
            for (TestAction action : this.testActions) {
                this.testCase.addTestAction(action);
            }
        }
        if (this.finalActions != null && this.finalActions.size() > 0) {
            for (TestAction action : this.finalActions) {
                this.testCase.addFinalAction(action);
            }
        }
        return this.testCase;
    }

    public Class getObjectType() {
        return TestCase.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void setFinalActions(List<TestAction> finalActions) {
        this.finalActions = finalActions;
    }

    public void setTestCase(TestCase testCase) {
        this.testCase = testCase;
    }

    public void setTestActions(List<TestAction> testActions) {
        this.testActions = testActions;
    }
}

