/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.config.xml;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.citrusframework.context.TestContextFactory;
import org.citrusframework.context.TestContextFactoryBean;
import org.citrusframework.endpoint.EndpointAdapter;
import org.citrusframework.endpoint.adapter.StaticResponseEndpointAdapter;
import org.citrusframework.message.MessageHeaderType;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.AbstractBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public class StaticResponseEndpointAdapterParser
extends AbstractBeanDefinitionParser {
    protected AbstractBeanDefinition parseInternal(Element element, ParserContext parserContext) {
        Element headerElement;
        Element payloadResource;
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(StaticResponseEndpointAdapterFactory.class);
        Element payloadData = DomUtils.getChildElementByTagName((Element)element, (String)"payload");
        if (payloadData != null) {
            builder.addPropertyValue("messagePayload", (Object)DomUtils.getTextValue((Element)payloadData));
        }
        if ((payloadResource = DomUtils.getChildElementByTagName((Element)element, (String)"resource")) != null) {
            builder.addPropertyValue("messagePayloadResource", (Object)payloadResource.getAttribute("file"));
            if (payloadResource.hasAttribute("charset")) {
                builder.addPropertyValue("messagePayloadResourceCharset", (Object)payloadResource.getAttribute("charset"));
            }
        }
        if ((headerElement = DomUtils.getChildElementByTagName((Element)element, (String)"header")) != null) {
            LinkedHashMap<String, String> messageHeaders = new LinkedHashMap<String, String>();
            List elements = DomUtils.getChildElementsByTagName((Element)headerElement, (String)"element");
            for (Element headerValue : elements) {
                String name = headerValue.getAttribute("name");
                String value = headerValue.getAttribute("value");
                String type = headerValue.getAttribute("type");
                if (StringUtils.hasText((String)type)) {
                    value = MessageHeaderType.createTypedValue((String)type, (String)value);
                }
                messageHeaders.put(name, value);
            }
            builder.addPropertyValue("messageHeader", messageHeaders);
        }
        return builder.getBeanDefinition();
    }

    public static class StaticResponseEndpointAdapterFactory
    implements FactoryBean<StaticResponseEndpointAdapter>,
    BeanNameAware {
        @Autowired(required=false)
        private TestContextFactoryBean testContextFactory;
        private String name;
        private EndpointAdapter fallbackEndpointAdapter;
        private String messagePayload;
        private String messagePayloadResource;
        private String messagePayloadResourceCharset;
        private Map<String, Object> messageHeader = new HashMap<String, Object>();

        public void setMessagePayload(String messagePayload) {
            this.messagePayload = messagePayload;
        }

        public void setMessagePayloadResource(String messagePayloadResource) {
            this.messagePayloadResource = messagePayloadResource;
        }

        public void setMessagePayloadResourceCharset(String messagePayloadResourceCharset) {
            this.messagePayloadResourceCharset = messagePayloadResourceCharset;
        }

        public void setMessageHeader(Map<String, Object> messageHeader) {
            this.messageHeader = messageHeader;
        }

        public void setFallbackEndpointAdapter(EndpointAdapter fallbackEndpointAdapter) {
            this.fallbackEndpointAdapter = fallbackEndpointAdapter;
        }

        public StaticResponseEndpointAdapter getObject() throws Exception {
            StaticResponseEndpointAdapter endpointAdapter = new StaticResponseEndpointAdapter();
            if (this.messagePayload != null) {
                endpointAdapter.setMessagePayload(this.messagePayload);
            }
            if (this.messagePayloadResource != null) {
                endpointAdapter.setMessagePayloadResource(this.messagePayloadResource);
            }
            if (this.messagePayloadResourceCharset != null) {
                endpointAdapter.setMessagePayloadResourceCharset(this.messagePayloadResource);
            }
            endpointAdapter.setMessageHeader(this.messageHeader);
            endpointAdapter.setTestContextFactory((TestContextFactory)this.testContextFactory);
            endpointAdapter.setName(this.name);
            if (this.fallbackEndpointAdapter != null) {
                endpointAdapter.setFallbackEndpointAdapter(this.fallbackEndpointAdapter);
            }
            return endpointAdapter;
        }

        public Class<?> getObjectType() {
            return StaticResponseEndpointAdapter.class;
        }

        public void setBeanName(String name) {
            this.name = name;
        }
    }
}

