/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.config.xml.parser;

import java.util.Map;
import java.util.Optional;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.spi.ResourcePathTypeResolver;
import org.citrusframework.spi.TypeResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface CitrusXmlConfigParser {
    public static final Logger LOG = LoggerFactory.getLogger(CitrusXmlConfigParser.class);
    public static final String RESOURCE_PATH = "META-INF/citrus/config/parser";
    public static final TypeResolver TYPE_RESOLVER = new ResourcePathTypeResolver("META-INF/citrus/config/parser");

    public static <T> Map<String, T> lookup(String category) {
        Map parser = TYPE_RESOLVER.resolveAll(category, "type", null);
        if (LOG.isDebugEnabled()) {
            parser.forEach((k, v) -> LOG.debug(String.format("Found XML config parser '%s/%s' as %s", category, k, v.getClass())));
        }
        return parser;
    }

    public static <T> Optional<T> lookup(String category, String name) {
        try {
            Object instance = TYPE_RESOLVER.resolve(category + "/" + name, new Object[0]);
            return Optional.of(instance);
        }
        catch (CitrusRuntimeException e) {
            LOG.warn(String.format("Failed to resolve XML config parser from resource '%s/%s/%s'", RESOURCE_PATH, category, name));
            return Optional.empty();
        }
    }
}

