/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.util;

import java.io.IOException;
import java.io.StringReader;
import java.util.Map;
import java.util.Properties;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.util.DefaultTypeConverter;
import org.springframework.beans.SimpleTypeConverter;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;

public final class SpringBeanTypeConverter
extends DefaultTypeConverter {
    public static SpringBeanTypeConverter INSTANCE = new SpringBeanTypeConverter();

    private SpringBeanTypeConverter() {
    }

    protected <T> T convertBefore(Object target, Class<T> type) {
        if (MultiValueMap.class.isAssignableFrom(type)) {
            String mapString = String.valueOf(target);
            Properties props = new Properties();
            try {
                props.load(new StringReader(mapString.substring(1, mapString.length() - 1).replaceAll("\\]\\s*", "]\n")));
            }
            catch (IOException e) {
                throw new CitrusRuntimeException("Failed to reconstruct object of type map", (Throwable)e);
            }
            LinkedMultiValueMap map = new LinkedMultiValueMap();
            for (Map.Entry<Object, Object> entry : props.entrySet()) {
                String arrayString = String.valueOf(entry.getValue()).replaceAll("^\\[", "").replaceAll("\\]$", "").replaceAll(",\\s", ",");
                map.add((Object)entry.getKey().toString(), (Object)StringUtils.commaDelimitedListToStringArray((String)String.valueOf(arrayString)));
            }
            return (T)map;
        }
        return null;
    }

    public <T> T convertAfter(Object target, Class<T> type) {
        return (T)new SimpleTypeConverter().convertIfNecessary(target, type);
    }
}

