/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.config.xml;

import java.util.LinkedHashMap;
import java.util.List;
import org.citrusframework.TestCase;
import org.citrusframework.config.CitrusNamespaceParserRegistry;
import org.citrusframework.config.TestCaseFactory;
import org.citrusframework.config.xml.DescriptionElementParser;
import org.citrusframework.util.StringUtils;
import org.citrusframework.variable.VariableUtils;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public class BaseTestCaseParser<T extends TestCase>
implements BeanDefinitionParser {
    private final Class<? extends TestCase> testCaseType;

    protected BaseTestCaseParser(Class<T> testCaseType) {
        this.testCaseType = testCaseType;
    }

    public final BeanDefinition parse(Element element, ParserContext parserContext) {
        BeanDefinitionBuilder testCaseFactory = BeanDefinitionBuilder.rootBeanDefinition(TestCaseFactory.class);
        BeanDefinitionBuilder testCase = BeanDefinitionBuilder.rootBeanDefinition(this.testCaseType);
        String testName = element.getAttribute("name");
        if (!StringUtils.hasText((String)testName)) {
            throw new BeanCreationException("Please provide proper test case name");
        }
        testCase.addPropertyValue("name", (Object)testName);
        this.parseMetaInfo(testCase, element, parserContext);
        this.parseVariableDefinitions(testCase, element);
        DescriptionElementParser.doParse(element, testCase);
        Element actionsElement = DomUtils.getChildElementByTagName((Element)element, (String)"actions");
        Element finallyBlockElement = DomUtils.getChildElementByTagName((Element)element, (String)"finally");
        testCaseFactory.addPropertyValue("testCase", (Object)testCase.getBeanDefinition());
        testCaseFactory.addPropertyValue("testActions", this.parseActions(actionsElement, parserContext));
        testCaseFactory.addPropertyValue("finalActions", this.parseActions(finallyBlockElement, parserContext));
        parserContext.getRegistry().registerBeanDefinition(testName, (BeanDefinition)testCaseFactory.getBeanDefinition());
        return parserContext.getRegistry().getBeanDefinition(testName);
    }

    private ManagedList<BeanDefinition> parseActions(Element actionsContainerElement, ParserContext parserContext) {
        ManagedList actions = new ManagedList();
        if (actionsContainerElement != null) {
            List actionList = DomUtils.getChildElements((Element)actionsContainerElement);
            for (Element action : actionList) {
                BeanDefinitionParser parser = null;
                if (action.getNamespaceURI().equals(actionsContainerElement.getNamespaceURI())) {
                    parser = CitrusNamespaceParserRegistry.getBeanParser(action.getLocalName());
                }
                if (parser == null) {
                    actions.add((Object)parserContext.getReaderContext().getNamespaceHandlerResolver().resolve(action.getNamespaceURI()).parse(action, parserContext));
                    continue;
                }
                actions.add((Object)parser.parse(action, parserContext));
            }
        }
        return actions;
    }

    private void parseVariableDefinitions(BeanDefinitionBuilder testCase, Element element) {
        Element variablesElement = DomUtils.getChildElementByTagName((Element)element, (String)"variables");
        if (variablesElement != null) {
            LinkedHashMap<String, String> testVariables = new LinkedHashMap<String, String>();
            List variableElements = DomUtils.getChildElementsByTagName((Element)variablesElement, (String)"variable");
            for (Element variableDefinition : variableElements) {
                Element variableData;
                Element variableValueElement = DomUtils.getChildElementByTagName((Element)variableDefinition, (String)"value");
                if (variableValueElement == null) {
                    testVariables.put(variableDefinition.getAttribute("name"), variableDefinition.getAttribute("value"));
                    continue;
                }
                Element variableScript = DomUtils.getChildElementByTagName((Element)variableValueElement, (String)"script");
                if (variableScript != null) {
                    String scriptEngine = variableScript.getAttribute("type");
                    testVariables.put(variableDefinition.getAttribute("name"), VariableUtils.getValueFromScript((String)scriptEngine, (String)variableScript.getTextContent()));
                }
                if ((variableData = DomUtils.getChildElementByTagName((Element)variableValueElement, (String)"data")) == null) continue;
                testVariables.put(variableDefinition.getAttribute("name"), DomUtils.getTextValue((Element)variableData).trim());
            }
            testCase.addPropertyValue("variableDefinitions", testVariables);
        }
    }

    private void parseMetaInfo(BeanDefinitionBuilder testCase, Element element, ParserContext parserContext) {
        Element metaInfoElement = DomUtils.getChildElementByTagName((Element)element, (String)"meta-info");
        if (metaInfoElement != null) {
            BeanDefinition metaInfoDefinition = CitrusNamespaceParserRegistry.getBeanParser("meta-info").parse(metaInfoElement, parserContext);
            testCase.addPropertyValue("metaInfo", (Object)metaInfoDefinition);
        }
    }
}

