/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.config.xml;

import org.citrusframework.actions.LoadPropertiesAction;
import org.citrusframework.config.util.BeanDefinitionParserUtils;
import org.citrusframework.config.xml.AbstractTestActionFactoryBean;
import org.citrusframework.config.xml.DescriptionElementParser;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public class LoadPropertiesActionParser
implements BeanDefinitionParser {
    public BeanDefinition parse(Element element, ParserContext parserContext) {
        BeanDefinitionBuilder beanDefinition = BeanDefinitionBuilder.rootBeanDefinition(LoadPropertiesActionFactoryBean.class);
        DescriptionElementParser.doParse(element, beanDefinition);
        Element propertiesElement = DomUtils.getChildElementByTagName((Element)element, (String)"properties");
        if (propertiesElement == null) {
            throw new BeanCreationException("Missing properties file definition for load action");
        }
        BeanDefinitionParserUtils.setPropertyValue(beanDefinition, propertiesElement.getAttribute("file"), "filePath");
        return beanDefinition.getBeanDefinition();
    }

    public static class LoadPropertiesActionFactoryBean
    extends AbstractTestActionFactoryBean<LoadPropertiesAction, LoadPropertiesAction.Builder> {
        private final LoadPropertiesAction.Builder builder = new LoadPropertiesAction.Builder();

        public void setFilePath(String file) {
            this.builder.filePath(file);
        }

        public LoadPropertiesAction getObject() throws Exception {
            return this.builder.build();
        }

        public Class<?> getObjectType() {
            return LoadPropertiesAction.class;
        }

        @Override
        public LoadPropertiesAction.Builder getBuilder() {
            return this.builder;
        }
    }
}

