/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.config.xml;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.citrusframework.variable.GlobalVariables;
import org.citrusframework.variable.GlobalVariablesPropertyLoader;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public class GlobalVariablesParser
implements BeanDefinitionParser {
    public static final String BEAN_NAME = "globalVariables";

    public BeanDefinition parse(Element element, ParserContext parserContext) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition(GlobalVariablesFactoryBean.class);
        this.parseVariableDefinitions(builder, element);
        parserContext.getRegistry().registerBeanDefinition(BEAN_NAME, (BeanDefinition)builder.getBeanDefinition());
        ArrayList<String> propertyFiles = new ArrayList<String>();
        List propertyFileElements = DomUtils.getChildElementsByTagName((Element)element, (String)"file");
        for (Element propertyFileElement : propertyFileElements) {
            propertyFiles.add(propertyFileElement.getAttribute("path"));
        }
        if (!propertyFiles.isEmpty()) {
            BeanDefinitionBuilder variablesPropertyLoader = BeanDefinitionBuilder.rootBeanDefinition(GlobalVariablesPropertyLoader.class);
            variablesPropertyLoader.addPropertyValue("propertyFiles", propertyFiles);
            parserContext.getRegistry().registerBeanDefinition("globalVariablesPropertyLoader", (BeanDefinition)variablesPropertyLoader.getBeanDefinition());
        }
        return null;
    }

    private void parseVariableDefinitions(BeanDefinitionBuilder builder, Element element) {
        LinkedHashMap<String, String> testVariables = new LinkedHashMap<String, String>();
        List variableElements = DomUtils.getChildElementsByTagName((Element)element, (String)"variable");
        for (Element variableDefinition : variableElements) {
            testVariables.put(variableDefinition.getAttribute("name"), variableDefinition.getAttribute("value"));
        }
        if (!testVariables.isEmpty()) {
            builder.addPropertyValue("variables", testVariables);
        }
    }

    public static class GlobalVariablesFactoryBean
    implements FactoryBean<GlobalVariables> {
        private final GlobalVariables.Builder builder = new GlobalVariables.Builder();

        public GlobalVariables getObject() throws Exception {
            return this.builder.build();
        }

        public void setVariables(Map<String, Object> variables) {
            this.builder.variables(variables);
        }

        public Class<?> getObjectType() {
            return GlobalVariables.class;
        }
    }
}

