/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.spi;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.spi.Resource;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.ConditionalConverter;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.io.ClassPathResource;

public class CitrusResourceWrapper
implements Resource {
    private final org.springframework.core.io.Resource delegate;

    public CitrusResourceWrapper(org.springframework.core.io.Resource delegate) {
        this.delegate = delegate;
    }

    public static CitrusResourceWrapper from(org.springframework.core.io.Resource resource) {
        return new CitrusResourceWrapper(resource);
    }

    public String getLocation() {
        try {
            org.springframework.core.io.Resource resource = this.delegate;
            if (resource instanceof ClassPathResource) {
                ClassPathResource classPathResource = (ClassPathResource)resource;
                return classPathResource.getURI().toString();
            }
            return this.delegate.getFile().getPath();
        }
        catch (IOException e) {
            return this.delegate.toString();
        }
    }

    public boolean exists() {
        return this.delegate.exists();
    }

    public InputStream getInputStream() {
        try {
            return this.delegate.getInputStream();
        }
        catch (IOException e) {
            throw new CitrusRuntimeException((Throwable)e);
        }
    }

    public File getFile() {
        try {
            return this.delegate.getFile();
        }
        catch (IOException e) {
            throw new CitrusRuntimeException((Throwable)e);
        }
    }

    public static class ResourceConverter
    implements Converter<org.springframework.core.io.Resource, Resource>,
    ConditionalConverter {
        public boolean matches(TypeDescriptor sourceType, TypeDescriptor targetType) {
            return org.springframework.core.io.Resource.class.isAssignableFrom(sourceType.getObjectType()) && Resource.class.isAssignableFrom(targetType.getObjectType());
        }

        public Resource convert(org.springframework.core.io.Resource source) {
            return new CitrusResourceWrapper(source);
        }
    }
}

