/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.io;

import java.beans.PropertyEditorSupport;
import java.io.IOException;
import org.citrusframework.spi.Resource;
import org.citrusframework.spi.Resources;
import org.springframework.core.env.PropertyResolver;
import org.springframework.core.env.StandardEnvironment;
import org.springframework.lang.Nullable;
import org.springframework.util.StringUtils;

public class CitrusResourceEditor
extends PropertyEditorSupport {
    @Nullable
    private PropertyResolver propertyResolver;
    private final boolean ignoreUnresolvablePlaceholders;

    public CitrusResourceEditor() {
        this(null);
    }

    public CitrusResourceEditor(@Nullable PropertyResolver propertyResolver) {
        this(propertyResolver, true);
    }

    public CitrusResourceEditor(@Nullable PropertyResolver propertyResolver, boolean ignoreUnresolvablePlaceholders) {
        this.propertyResolver = propertyResolver;
        this.ignoreUnresolvablePlaceholders = ignoreUnresolvablePlaceholders;
    }

    @Override
    public void setAsText(String text) {
        if (StringUtils.hasText((String)text)) {
            String locationToUse = this.resolvePath(text).trim();
            this.setValue(Resources.create((String)locationToUse));
        } else {
            this.setValue(null);
        }
    }

    protected String resolvePath(String path) {
        if (this.propertyResolver == null) {
            this.propertyResolver = new StandardEnvironment();
        }
        return this.ignoreUnresolvablePlaceholders ? this.propertyResolver.resolvePlaceholders(path) : this.propertyResolver.resolveRequiredPlaceholders(path);
    }

    @Override
    @Nullable
    public String getAsText() {
        Resource value = (Resource)this.getValue();
        try {
            return value != null ? value.getURL().toExternalForm() : "";
        }
        catch (IOException ex) {
            return null;
        }
    }
}

