/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.util.DefaultTypeConverter;
import org.citrusframework.util.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.SimpleTypeConverter;
import org.springframework.core.io.InputStreamSource;
import org.springframework.core.io.Resource;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

public final class SpringBeanTypeConverter
extends DefaultTypeConverter {
    private static final Logger logger = LoggerFactory.getLogger(DefaultTypeConverter.class);
    public static SpringBeanTypeConverter INSTANCE = new SpringBeanTypeConverter();

    private SpringBeanTypeConverter() {
    }

    protected <T> Optional<T> convertBefore(Object target, Class<T> type) {
        if (Source.class.isAssignableFrom(type) && target.getClass().isAssignableFrom(InputStreamSource.class)) {
            try {
                return Optional.of(new StreamSource(((InputStreamSource)target).getInputStream()));
            }
            catch (IOException e) {
                logger.warn("Failed to create stream source from object", (Throwable)e);
            }
        }
        if (target.getClass().isAssignableFrom(Resource.class)) {
            Resource resource = (Resource)target;
            if (File.class.isAssignableFrom(type)) {
                try {
                    return Optional.of(resource.getFile());
                }
                catch (IOException e) {
                    throw new CitrusRuntimeException("Failed to access file from resource", (Throwable)e);
                }
            }
            if (InputStream.class.isAssignableFrom(type)) {
                try {
                    return Optional.of(resource.getInputStream());
                }
                catch (IOException e) {
                    throw new CitrusRuntimeException("Failed to access input stream of resource", (Throwable)e);
                }
            }
            if (byte[].class.isAssignableFrom(type)) {
                try {
                    return Optional.of(FileUtils.copyToByteArray((InputStream)resource.getInputStream()));
                }
                catch (IOException e) {
                    throw new CitrusRuntimeException("Failed to access content of resource", (Throwable)e);
                }
            }
        }
        if (MultiValueMap.class.isAssignableFrom(type)) {
            String mapString = String.valueOf(target);
            Properties props = new Properties();
            try {
                props.load(new StringReader(mapString.substring(1, mapString.length() - 1).replaceAll("\\]\\s*", "]\n")));
            }
            catch (IOException e) {
                throw new CitrusRuntimeException("Failed to reconstruct object of type map", (Throwable)e);
            }
            LinkedMultiValueMap map = new LinkedMultiValueMap();
            for (Map.Entry<Object, Object> entry : props.entrySet()) {
                String arrayString = String.valueOf(entry.getValue()).replaceAll("^\\[", "").replaceAll("\\]$", "").replaceAll(",\\s", ",");
                map.add((Object)entry.getKey().toString(), (Object)arrayString.split(","));
            }
            return Optional.of(map);
        }
        return Optional.empty();
    }

    public <T> T convertAfter(Object target, Class<T> type) {
        return (T)new SimpleTypeConverter().convertIfNecessary(target, type);
    }
}

