/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.reporter;

import org.citrusframework.report.HtmlReporter;
import org.citrusframework.report.JUnitReporter;
import org.citrusframework.report.LoggingReporter;
import org.citrusframework.reporter.TestReportersFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Condition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.type.AnnotatedTypeMetadata;

@Configuration
public class ReporterConfig {
    public static final String CITRUS_LOGGING_REPORTER = "citrusLoggingReporter";
    public static final String CITRUS_JUNIT_REPORTER = "citrusJunitReporter";
    public static final String CITRUS_HTML_REPORTER = "citrusHtmlReporter";
    public static final String DEFAULT_LOGGING_REPORTER_ENABLED_PROPERTY = "citrus.default.logging.reporter.enabled";
    public static final String DEFAULT_JUNIT_REPORTER_ENABLED_PROPERTY = "citrus.default.junit.reporter.enabled";
    public static final String DEFAULT_HTML_REPORTER_ENABLED_PROPERTY = "citrus.default.html.reporter.enabled";

    @Bean(name={"citrusLoggingReporter"})
    @Conditional(value={LoggingReporterEnablementCondition.class})
    public LoggingReporter loggingReporter() {
        return new LoggingReporter();
    }

    @Bean(name={"citrusHtmlReporter"})
    @Conditional(value={HtmlReporterEnablementCondition.class})
    public HtmlReporter htmlReporter() {
        return new HtmlReporter();
    }

    @Bean(name={"citrusJunitReporter"})
    @Conditional(value={JunitReporterEnablementCondition.class})
    public JUnitReporter junitReporter() {
        return new JUnitReporter();
    }

    @Bean(name={"citrusTestReporters"})
    public TestReportersFactory testReporters() {
        return new TestReportersFactory();
    }

    static class HtmlReporterEnablementCondition
    implements Condition {
        HtmlReporterEnablementCondition() {
        }

        public boolean matches(ConditionContext context, AnnotatedTypeMetadata metadata) {
            return "true".equals(context.getEnvironment().getProperty(ReporterConfig.DEFAULT_HTML_REPORTER_ENABLED_PROPERTY, "true"));
        }
    }

    static class JunitReporterEnablementCondition
    implements Condition {
        JunitReporterEnablementCondition() {
        }

        public boolean matches(ConditionContext context, AnnotatedTypeMetadata metadata) {
            return "true".equals(context.getEnvironment().getProperty(ReporterConfig.DEFAULT_JUNIT_REPORTER_ENABLED_PROPERTY, "true"));
        }
    }

    static class LoggingReporterEnablementCondition
    implements Condition {
        LoggingReporterEnablementCondition() {
        }

        public boolean matches(ConditionContext context, AnnotatedTypeMetadata metadata) {
            return "true".equals(context.getEnvironment().getProperty(ReporterConfig.DEFAULT_LOGGING_REPORTER_ENABLED_PROPERTY, "true"));
        }
    }
}

