/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.config.xml;

import java.util.ArrayList;
import java.util.List;
import org.citrusframework.actions.JavaAction;
import org.citrusframework.config.util.BeanDefinitionParserUtils;
import org.citrusframework.config.xml.AbstractTestActionFactoryBean;
import org.citrusframework.config.xml.DescriptionElementParser;
import org.citrusframework.util.StringUtils;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public class JavaActionParser
implements BeanDefinitionParser {
    public BeanDefinition parse(Element element, ParserContext parserContext) {
        BeanDefinitionBuilder beanDefinition = BeanDefinitionBuilder.rootBeanDefinition(JavaActionFactoryBean.class);
        DescriptionElementParser.doParse(element, beanDefinition);
        BeanDefinitionParserUtils.setPropertyValue(beanDefinition, element.getAttribute("class"), "className");
        BeanDefinitionParserUtils.setPropertyReference(beanDefinition, element.getAttribute("ref"), "instance");
        Element constructorElement = DomUtils.getChildElementByTagName((Element)element, (String)"constructor");
        ArrayList<Object> arguments = new ArrayList<Object>();
        if (constructorElement != null) {
            List argumentList = DomUtils.getChildElementsByTagName((Element)constructorElement, (String)"argument");
            for (Element arg : argumentList) {
                arguments.add(this.resolveArgument(arg.getAttribute("type"), arg.getTextContent()));
            }
            beanDefinition.addPropertyValue("constructorArgs", arguments);
        }
        Element methodElement = DomUtils.getChildElementByTagName((Element)element, (String)"method");
        arguments = new ArrayList();
        if (methodElement != null) {
            String methodName = methodElement.getAttribute("name");
            beanDefinition.addPropertyValue("methodName", (Object)methodName);
            List argumentList = DomUtils.getChildElementsByTagName((Element)methodElement, (String)"argument");
            for (Element arg : argumentList) {
                arguments.add(this.resolveArgument(arg.getAttribute("type"), DomUtils.getTextValue((Element)arg)));
            }
            beanDefinition.addPropertyValue("methodArgs", arguments);
        }
        return beanDefinition.getBeanDefinition();
    }

    private Object resolveArgument(String type, String value) {
        if (!StringUtils.hasText((String)type) || type.equals("String")) {
            return value;
        }
        if (type.equals("String[]")) {
            return value.split(",");
        }
        if (type.equals("boolean")) {
            return Boolean.parseBoolean(value);
        }
        if (type.equals("int")) {
            return Integer.parseInt(value);
        }
        if (type.equals("long")) {
            return Long.parseLong(value);
        }
        if (type.equals("double")) {
            return Double.parseDouble(value);
        }
        throw new BeanCreationException("Found unsupported method argument type: '" + type + "'");
    }

    public static class JavaActionFactoryBean
    extends AbstractTestActionFactoryBean<JavaAction, JavaAction.Builder> {
        private final JavaAction.Builder builder = new JavaAction.Builder();

        public void setClassName(String className) {
            this.builder.className(className);
        }

        public void setConstructorArgs(List<Object> constructorArgs) {
            this.builder.constructorArgs(constructorArgs);
        }

        public void setMethodArgs(List<Object> methodArgs) {
            this.builder.methodArgs(methodArgs);
        }

        public void setMethodName(String methodName) {
            this.builder.method(methodName);
        }

        public void setInstance(Object instance) {
            this.builder.instance(instance);
        }

        public JavaAction getObject() throws Exception {
            return this.builder.build();
        }

        public Class<?> getObjectType() {
            return JavaAction.class;
        }

        @Override
        public JavaAction.Builder getBuilder() {
            return this.builder;
        }
    }
}

