/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.config.xml;

import org.citrusframework.functions.FunctionLibrary;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedMap;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public class FunctionLibraryParser
implements BeanDefinitionParser {
    public BeanDefinition parse(Element element, ParserContext parserContext) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition(FunctionLibrary.class);
        this.parseFunctionDefinitions(builder, element);
        builder.addPropertyValue("prefix", (Object)element.getAttribute("prefix"));
        builder.addPropertyValue("name", (Object)element.getAttribute("id"));
        parserContext.getRegistry().registerBeanDefinition(element.getAttribute("id"), (BeanDefinition)builder.getBeanDefinition());
        return null;
    }

    private void parseFunctionDefinitions(BeanDefinitionBuilder builder, Element element) {
        ManagedMap functions = new ManagedMap();
        for (Element function : DomUtils.getChildElementsByTagName((Element)element, (String)"function")) {
            if (function.hasAttribute("ref")) {
                functions.put((Object)function.getAttribute("name"), (Object)new RuntimeBeanReference(function.getAttribute("ref")));
                continue;
            }
            functions.put((Object)function.getAttribute("name"), (Object)BeanDefinitionBuilder.rootBeanDefinition((String)function.getAttribute("class")).getBeanDefinition());
        }
        if (!functions.isEmpty()) {
            builder.addPropertyValue("members", (Object)functions);
        }
    }
}

