/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.config.xml;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.citrusframework.actions.ExecuteSQLAction;
import org.citrusframework.actions.ExecuteSQLQueryAction;
import org.citrusframework.config.util.BeanDefinitionParserUtils;
import org.citrusframework.config.xml.AbstractDatabaseConnectingTestActionFactoryBean;
import org.citrusframework.config.xml.DescriptionElementParser;
import org.citrusframework.util.StringUtils;
import org.citrusframework.validation.script.DefaultScriptValidationContext;
import org.citrusframework.validation.script.ScriptValidationContext;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public class SQLActionParser
implements BeanDefinitionParser {
    public BeanDefinition parse(Element element, ParserContext parserContext) {
        BeanDefinitionBuilder beanDefinition;
        String dataSource = element.getAttribute("datasource");
        if (!StringUtils.hasText((String)dataSource)) {
            throw new BeanCreationException("Missing proper data source reference");
        }
        List validateElements = DomUtils.getChildElementsByTagName((Element)element, (String)"validate");
        List extractElements = DomUtils.getChildElementsByTagName((Element)element, (String)"extract");
        Element scriptValidationElement = DomUtils.getChildElementByTagName((Element)element, (String)"validate-script");
        if (validateElements.isEmpty() && extractElements.isEmpty() && scriptValidationElement == null) {
            beanDefinition = this.parseSqlAction(element);
            beanDefinition.addPropertyValue("name", (Object)("sqlUpdate:" + dataSource));
        } else {
            beanDefinition = this.parseSqlQueryAction(element, scriptValidationElement, validateElements, extractElements);
            beanDefinition.addPropertyValue("name", (Object)("sqlQuery:" + dataSource));
        }
        beanDefinition.addPropertyReference("dataSource", dataSource);
        BeanDefinitionParserUtils.setPropertyReference((BeanDefinitionBuilder)beanDefinition, (String)element.getAttribute("transaction-manager"), (String)"transactionManager");
        BeanDefinitionParserUtils.setPropertyValue((BeanDefinitionBuilder)beanDefinition, (String)element.getAttribute("transaction-timeout"), (String)"transactionTimeout");
        BeanDefinitionParserUtils.setPropertyValue((BeanDefinitionBuilder)beanDefinition, (String)element.getAttribute("transaction-isolation-level"), (String)"transactionIsolationLevel");
        DescriptionElementParser.doParse((Element)element, (BeanDefinitionBuilder)beanDefinition);
        ArrayList<String> statements = new ArrayList<String>();
        List stmtElements = DomUtils.getChildElementsByTagName((Element)element, (String)"statement");
        for (Element stmt : stmtElements) {
            statements.add(DomUtils.getTextValue((Element)stmt));
        }
        beanDefinition.addPropertyValue("statements", statements);
        Element sqlResourceElement = DomUtils.getChildElementByTagName((Element)element, (String)"resource");
        if (sqlResourceElement != null) {
            beanDefinition.addPropertyValue("sqlResourcePath", (Object)sqlResourceElement.getAttribute("file"));
        }
        return beanDefinition.getBeanDefinition();
    }

    private BeanDefinitionBuilder parseSqlAction(Element element) {
        BeanDefinitionBuilder beanDefinition = BeanDefinitionBuilder.rootBeanDefinition(ExecuteSQLActionFactoryBean.class);
        String ignoreErrors = element.getAttribute("ignore-errors");
        if (ignoreErrors != null && ignoreErrors.equals("true")) {
            beanDefinition.addPropertyValue("ignoreErrors", (Object)true);
        }
        return beanDefinition;
    }

    private BeanDefinitionBuilder parseSqlQueryAction(Element element, Element scriptValidationElement, List<Element> validateElements, List<Element> extractElements) {
        BeanDefinitionBuilder beanDefinition = BeanDefinitionBuilder.rootBeanDefinition(ExecuteSQLQueryActionFactoryBean.class);
        if (scriptValidationElement != null) {
            beanDefinition.addPropertyValue("scriptValidationContext", (Object)this.getScriptValidationContext(scriptValidationElement));
        }
        HashMap<String, List<Object>> controlResultSet = new HashMap<String, List<Object>>();
        for (Element validateElement : validateElements) {
            Element valueListElement = DomUtils.getChildElementByTagName((Element)validateElement, (String)"values");
            if (valueListElement != null) {
                ArrayList<String> valueList = new ArrayList<String>();
                List valueElements = DomUtils.getChildElementsByTagName((Element)valueListElement, (String)"value");
                for (Element valueElement : valueElements) {
                    valueList.add(DomUtils.getTextValue((Element)valueElement));
                }
                controlResultSet.put(validateElement.getAttribute("column"), valueList);
                continue;
            }
            if (validateElement.hasAttribute("value")) {
                controlResultSet.put(validateElement.getAttribute("column"), Collections.singletonList(validateElement.getAttribute("value")));
                continue;
            }
            throw new BeanCreationException(element.getLocalName(), "Neither value attribute nor value list is set for column validation: " + validateElement.getAttribute("column"));
        }
        beanDefinition.addPropertyValue("controlResultSet", controlResultSet);
        HashMap<String, String> extractVariables = new HashMap<String, String>();
        for (Element validate : extractElements) {
            extractVariables.put(validate.getAttribute("column"), validate.getAttribute("variable"));
        }
        beanDefinition.addPropertyValue("extractVariables", extractVariables);
        return beanDefinition;
    }

    private ScriptValidationContext getScriptValidationContext(Element scriptElement) {
        String type = scriptElement.getAttribute("type");
        DefaultScriptValidationContext.Builder validationContext = new DefaultScriptValidationContext.Builder().scriptType(type);
        String filePath = scriptElement.getAttribute("file");
        if (StringUtils.hasText((String)filePath)) {
            validationContext.scriptResource(filePath);
        } else {
            validationContext.script(DomUtils.getTextValue((Element)scriptElement));
        }
        return (ScriptValidationContext)validationContext.build();
    }

    public static class ExecuteSQLActionFactoryBean
    extends AbstractDatabaseConnectingTestActionFactoryBean<ExecuteSQLAction, ExecuteSQLAction.Builder> {
        private final ExecuteSQLAction.Builder builder = new ExecuteSQLAction.Builder();

        public ExecuteSQLAction getObject() throws Exception {
            return (ExecuteSQLAction)this.builder.build();
        }

        public void setIgnoreErrors(boolean ignoreErrors) {
            this.builder.ignoreErrors(ignoreErrors);
        }

        public Class<?> getObjectType() {
            return ExecuteSQLAction.class;
        }

        public ExecuteSQLAction.Builder getBuilder() {
            return this.builder;
        }
    }

    public static class ExecuteSQLQueryActionFactoryBean
    extends AbstractDatabaseConnectingTestActionFactoryBean<ExecuteSQLQueryAction, ExecuteSQLQueryAction.Builder> {
        private final ExecuteSQLQueryAction.Builder builder = new ExecuteSQLQueryAction.Builder();

        public ExecuteSQLQueryAction getObject() throws Exception {
            return (ExecuteSQLQueryAction)this.builder.build();
        }

        public void setControlResultSet(Map<String, List<String>> controlResultSet) {
            controlResultSet.forEach((key, value) -> this.builder.validate((String)key, value.toArray(new String[0])));
        }

        public void setExtractVariables(Map<String, String> variablesMap) {
            variablesMap.forEach(this.builder::extract);
        }

        public void setScriptValidationContext(ScriptValidationContext scriptValidationContext) {
            this.builder.validate(scriptValidationContext);
        }

        public Class<?> getObjectType() {
            return ExecuteSQLQueryAction.class;
        }

        public ExecuteSQLQueryAction.Builder getBuilder() {
            return this.builder;
        }
    }
}

