/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.sql.xml;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import java.util.ArrayList;
import java.util.List;
import org.citrusframework.TestActionBuilder;
import org.citrusframework.actions.ExecutePLSQLAction;
import org.citrusframework.spi.ReferenceResolver;
import org.citrusframework.spi.ReferenceResolverAware;
import org.springframework.transaction.PlatformTransactionManager;

@XmlRootElement(name="plsql")
public class Plsql
implements TestActionBuilder<ExecutePLSQLAction>,
ReferenceResolverAware {
    private final ExecutePLSQLAction.Builder builder = new ExecutePLSQLAction.Builder();
    private String transactionManager;
    private ReferenceResolver referenceResolver;

    @XmlElement
    public Plsql setDescription(String value) {
        this.builder.description(value);
        return this;
    }

    @XmlAttribute(name="datasource", required=true)
    public Plsql setDataSource(String dataSource) {
        this.builder.dataSource(dataSource);
        this.builder.name(String.format("plsql:%s", dataSource));
        return this;
    }

    @XmlElement(required=true)
    public Plsql setStatements(Statements statements) {
        statements.getStatements().forEach(this.builder::statement);
        if (statements.file != null) {
            this.builder.sqlResource(statements.file);
        }
        if (statements.script != null) {
            this.builder.sqlScript(statements.script);
        }
        return this;
    }

    @XmlElement(name="transaction")
    public Plsql setTransaction(Transaction transaction) {
        if (transaction.manager != null) {
            this.transactionManager = transaction.manager;
        }
        if (transaction.isolationLevel != null) {
            this.builder.transactionIsolationLevel(transaction.isolationLevel);
        }
        if (transaction.timeout != null) {
            this.builder.transactionTimeout(transaction.timeout);
        }
        return this;
    }

    @XmlAttribute(name="ignore-errors")
    public Plsql setIgnoreErrors(boolean value) {
        this.builder.ignoreErrors(value);
        return this;
    }

    public ExecutePLSQLAction build() {
        if (this.referenceResolver != null) {
            this.builder.withReferenceResolver(this.referenceResolver);
            if (this.transactionManager != null) {
                this.builder.transactionManager(this.referenceResolver.resolve(this.transactionManager, PlatformTransactionManager.class));
            }
        }
        return (ExecutePLSQLAction)this.builder.build();
    }

    public void setReferenceResolver(ReferenceResolver referenceResolver) {
        this.referenceResolver = referenceResolver;
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    @XmlType(name="", propOrder={"statements", "script"})
    public static class Statements {
        @XmlElement(name="script")
        private String script;
        @XmlElement(name="statement")
        private List<String> statements;
        @XmlAttribute(name="file")
        protected String file;

        public String getScript() {
            return this.script;
        }

        public void setScript(String script) {
            this.script = script;
        }

        public String getFile() {
            return this.file;
        }

        public void setFile(String value) {
            this.file = value;
        }

        public List<String> getStatements() {
            if (this.statements == null) {
                this.statements = new ArrayList<String>();
            }
            return this.statements;
        }
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    @XmlType(name="")
    public static class Transaction {
        @XmlAttribute(name="manager")
        protected String manager;
        @XmlAttribute(name="timeout")
        protected String timeout;
        @XmlAttribute(name="isolation-level")
        protected String isolationLevel;

        public String getManager() {
            return this.manager;
        }

        public void setManager(String manager) {
            this.manager = manager;
        }

        public String getTimeout() {
            return this.timeout;
        }

        public void setTimeout(String timeout) {
            this.timeout = timeout;
        }

        public String getIsolationLevel() {
            return this.isolationLevel;
        }

        public void setIsolationLevel(String isolationLevel) {
            this.isolationLevel = isolationLevel;
        }
    }
}

