/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.ssh.client;

import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.UserInfo;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.citrusframework.context.TestContext;
import org.citrusframework.endpoint.AbstractEndpoint;
import org.citrusframework.endpoint.EndpointConfiguration;
import org.citrusframework.endpoint.PollableEndpointConfiguration;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.exceptions.MessageTimeoutException;
import org.citrusframework.message.Message;
import org.citrusframework.message.correlation.CorrelationManager;
import org.citrusframework.message.correlation.PollingCorrelationManager;
import org.citrusframework.messaging.Producer;
import org.citrusframework.messaging.ReplyConsumer;
import org.citrusframework.messaging.SelectiveConsumer;
import org.citrusframework.ssh.client.SshEndpointConfiguration;
import org.citrusframework.ssh.model.SshRequest;
import org.citrusframework.ssh.model.SshResponse;
import org.citrusframework.util.FileUtils;
import org.citrusframework.util.StringUtils;

public class SshClient
extends AbstractEndpoint
implements Producer,
ReplyConsumer {
    private CorrelationManager<Message> correlationManager;
    private Session session;
    private JSch jsch = new JSch();

    public SshClient() {
        this(new SshEndpointConfiguration());
    }

    protected SshClient(SshEndpointConfiguration endpointConfiguration) {
        super((EndpointConfiguration)endpointConfiguration);
        this.correlationManager = new PollingCorrelationManager((PollableEndpointConfiguration)endpointConfiguration, "Reply message did not arrive yet");
    }

    public SshEndpointConfiguration getEndpointConfiguration() {
        return (SshEndpointConfiguration)super.getEndpointConfiguration();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(Message message, TestContext context) {
        int rc;
        String correlationKeyName = this.getEndpointConfiguration().getCorrelator().getCorrelationKeyName(this.getName());
        String correlationKey = this.getEndpointConfiguration().getCorrelator().getCorrelationKey(message);
        this.correlationManager.saveCorrelationKey(correlationKeyName, correlationKey, context);
        SshRequest request = (SshRequest)this.getEndpointConfiguration().getMessageConverter().convertOutbound(message, this.getEndpointConfiguration(), context);
        if (this.getEndpointConfiguration().isStrictHostChecking()) {
            this.setKnownHosts();
        }
        String rUser = this.getRemoteUser(message);
        this.connect(rUser);
        ChannelExec channelExec = null;
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        ByteArrayOutputStream errStream = new ByteArrayOutputStream();
        try {
            channelExec = this.openChannelExec();
            channelExec.setErrStream((OutputStream)errStream);
            channelExec.setOutputStream((OutputStream)outStream);
            channelExec.setCommand(request.getCommand());
            this.doConnect(channelExec);
            if (request.getStdin() != null) {
                this.sendStandardInput(channelExec, request.getStdin());
            }
            this.waitCommandToFinish(channelExec);
            rc = channelExec.getExitStatus();
        }
        finally {
            if (channelExec != null && channelExec.isConnected()) {
                channelExec.disconnect();
            }
            this.disconnect();
        }
        SshResponse sshResp = new SshResponse(outStream.toString(), errStream.toString(), rc);
        Message response = this.getEndpointConfiguration().getMessageConverter().convertInbound(sshResp, this.getEndpointConfiguration(), context).setHeader("user", (Object)rUser);
        this.correlationManager.store(correlationKey, (Object)response);
    }

    public Message receive(TestContext context) {
        return this.receive(this.correlationManager.getCorrelationKey(this.getEndpointConfiguration().getCorrelator().getCorrelationKeyName(this.getName()), context), context);
    }

    public Message receive(String selector, TestContext context) {
        return this.receive(selector, context, this.getEndpointConfiguration().getTimeout());
    }

    public Message receive(TestContext context, long timeout) {
        return this.receive(this.correlationManager.getCorrelationKey(this.getEndpointConfiguration().getCorrelator().getCorrelationKeyName(this.getName()), context), context, timeout);
    }

    public Message receive(String selector, TestContext context, long timeout) {
        Message message = (Message)this.correlationManager.find(selector, timeout);
        if (message == null) {
            throw new MessageTimeoutException(timeout, "SSH server out stream");
        }
        return message;
    }

    public Producer createProducer() {
        return this;
    }

    public SelectiveConsumer createConsumer() {
        return this;
    }

    private void connect(String rUser) {
        if (this.session == null || !this.session.isConnected()) {
            try {
                if (StringUtils.hasText((String)this.getEndpointConfiguration().getPrivateKeyPath())) {
                    this.jsch.addIdentity(this.getPrivateKeyPath(), this.getEndpointConfiguration().getPrivateKeyPassword());
                }
            }
            catch (JSchException e) {
                throw new CitrusRuntimeException("Cannot add private key " + this.getEndpointConfiguration().getPrivateKeyPath() + ": " + e, (Throwable)e);
            }
            catch (IOException e) {
                throw new CitrusRuntimeException("Cannot open private key file " + this.getEndpointConfiguration().getPrivateKeyPath() + ": " + e, (Throwable)e);
            }
            try {
                this.session = this.jsch.getSession(rUser, this.getEndpointConfiguration().getHost(), this.getEndpointConfiguration().getPort());
                if (StringUtils.hasText((String)this.getEndpointConfiguration().getPassword())) {
                    this.session.setUserInfo((UserInfo)new UserInfoWithPlainPassword(this.getEndpointConfiguration().getPassword()));
                    this.session.setPassword(this.getEndpointConfiguration().getPassword());
                }
                this.session.setConfig("StrictHostKeyChecking", this.getEndpointConfiguration().isStrictHostChecking() ? "yes" : "no");
                this.session.connect();
            }
            catch (JSchException e) {
                throw new CitrusRuntimeException("Cannot connect via SSH: " + e, (Throwable)e);
            }
        }
    }

    private void disconnect() {
        if (this.session.isConnected()) {
            this.session.disconnect();
        }
    }

    private ChannelExec openChannelExec() throws CitrusRuntimeException {
        ChannelExec channelExec;
        try {
            channelExec = (ChannelExec)this.session.openChannel("exec");
        }
        catch (JSchException e) {
            throw new CitrusRuntimeException("Cannot open EXEC SSH channel: " + e, (Throwable)e);
        }
        return channelExec;
    }

    private void waitCommandToFinish(ChannelExec pCh) {
        long until = System.currentTimeMillis() + this.getEndpointConfiguration().getCommandTimeout();
        try {
            while (!pCh.isClosed() && System.currentTimeMillis() < until) {
                Thread.sleep(250L);
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Interrupted", e);
        }
        if (!pCh.isClosed()) {
            throw new CitrusRuntimeException("Timeout: Channel not finished within " + this.getEndpointConfiguration().getCommandTimeout() + " ms");
        }
    }

    private void sendStandardInput(ChannelExec pCh, String pInput) {
        OutputStream os = null;
        try {
            os = pCh.getOutputStream();
            os.write(pInput.getBytes());
        }
        catch (IOException e) {
            throw new CitrusRuntimeException("Cannot write to standard input of SSH channel: " + e, (Throwable)e);
        }
        finally {
            if (os != null) {
                try {
                    os.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private void doConnect(ChannelExec pCh) {
        try {
            if (this.getEndpointConfiguration().getConnectionTimeout() != 0) {
                pCh.connect(this.getEndpointConfiguration().getConnectionTimeout());
            } else {
                pCh.connect();
            }
        }
        catch (JSchException e) {
            throw new CitrusRuntimeException("Cannot connect EXEC SSH channel: " + e, (Throwable)e);
        }
    }

    private String getRemoteUser(Message message) {
        String rUser = (String)message.getHeader("user");
        if (rUser == null) {
            rUser = this.getEndpointConfiguration().getUser();
        }
        if (rUser == null) {
            throw new CitrusRuntimeException("No user given for connecting to SSH server");
        }
        return rUser;
    }

    private void setKnownHosts() {
        if (this.getEndpointConfiguration().getKnownHosts() == null) {
            throw new CitrusRuntimeException("Strict host checking is enabled but no knownHosts given");
        }
        try {
            InputStream khIs = FileUtils.getFileResource((String)this.getEndpointConfiguration().getKnownHosts()).getInputStream();
            if (khIs == null) {
                throw new CitrusRuntimeException("Cannot find knownHosts at " + this.getEndpointConfiguration().getKnownHosts());
            }
            this.jsch.setKnownHosts(khIs);
        }
        catch (JSchException e) {
            throw new CitrusRuntimeException("Cannot add known hosts from " + this.getEndpointConfiguration().getKnownHosts() + ": " + e, (Throwable)e);
        }
    }

    private String getPrivateKeyPath() throws IOException {
        if (!StringUtils.hasText((String)this.getEndpointConfiguration().getPrivateKeyPath())) {
            return null;
        }
        if (this.getEndpointConfiguration().getPrivateKeyPath().startsWith("classpath:")) {
            File priv = File.createTempFile("citrus-ssh", "priv");
            try (InputStream is = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(this.getEndpointConfiguration().getPrivateKeyPath().substring("classpath:".length()));
                 FileOutputStream fos = new FileOutputStream(priv);){
                if (is == null) {
                    throw new CitrusRuntimeException("No private key found at " + this.getEndpointConfiguration().getPrivateKeyPath());
                }
                fos.write(is.readAllBytes());
                fos.flush();
            }
            return priv.getAbsolutePath();
        }
        return this.getEndpointConfiguration().getPrivateKeyPath();
    }

    public JSch getJsch() {
        return this.jsch;
    }

    public void setJsch(JSch jsch) {
        this.jsch = jsch;
    }

    public void setCorrelationManager(CorrelationManager<Message> correlationManager) {
        this.correlationManager = correlationManager;
    }

    private static class UserInfoWithPlainPassword
    implements UserInfo {
        private String password;

        public UserInfoWithPlainPassword(String pPassword) {
            this.password = pPassword;
        }

        public String getPassphrase() {
            return null;
        }

        public String getPassword() {
            return this.password;
        }

        public boolean promptPassword(String message) {
            return false;
        }

        public boolean promptPassphrase(String message) {
            return false;
        }

        public boolean promptYesNo(String message) {
            return false;
        }

        public void showMessage(String message) {
        }
    }
}

