/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.ssh.server;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.sshd.common.file.FileSystemFactory;
import org.apache.sshd.common.file.virtualfs.VirtualFileSystemFactory;
import org.apache.sshd.common.keyprovider.ClassLoadableResourceKeyPairProvider;
import org.apache.sshd.common.keyprovider.FileKeyPairProvider;
import org.apache.sshd.common.keyprovider.KeyPairProvider;
import org.apache.sshd.scp.common.AbstractScpTransferEventListenerAdapter;
import org.apache.sshd.scp.common.ScpTransferEventListener;
import org.apache.sshd.scp.server.ScpCommandFactory;
import org.apache.sshd.server.auth.password.PasswordAuthenticator;
import org.apache.sshd.server.auth.pubkey.PublickeyAuthenticator;
import org.apache.sshd.server.command.CommandFactory;
import org.apache.sshd.sftp.server.AbstractSftpEventListenerAdapter;
import org.apache.sshd.sftp.server.SftpEventListener;
import org.apache.sshd.sftp.server.SftpSubsystemFactory;
import org.citrusframework.endpoint.AbstractPollableEndpointConfiguration;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.server.AbstractServer;
import org.citrusframework.spi.Resource;
import org.citrusframework.spi.Resources;
import org.citrusframework.ssh.SshCommand;
import org.citrusframework.ssh.client.SshEndpointConfiguration;
import org.citrusframework.ssh.message.SshMessageConverter;
import org.citrusframework.ssh.model.SshMarshaller;
import org.citrusframework.ssh.server.SimplePasswordAuthenticator;
import org.citrusframework.ssh.server.SinglePublicKeyAuthenticator;
import org.citrusframework.util.FileUtils;
import org.citrusframework.util.StringUtils;

public class SshServer
extends AbstractServer {
    private int port = 22;
    private String user;
    private String password;
    private String allowedKeyPath;
    private String hostKeyPath;
    private String userHomePath;
    private SshMessageConverter messageConverter = new SshMessageConverter();
    private org.apache.sshd.server.SshServer sshd;
    private final SshEndpointConfiguration endpointConfiguration;

    public SshServer() {
        this(new SshEndpointConfiguration());
    }

    public SshServer(SshEndpointConfiguration endpointConfiguration) {
        this.endpointConfiguration = endpointConfiguration;
    }

    protected void startup() {
        if (!StringUtils.hasText((String)this.user)) {
            throw new CitrusRuntimeException("No 'user' provided (mandatory for authentication)");
        }
        this.sshd = org.apache.sshd.server.SshServer.setUpDefaultServer();
        this.sshd.setPort(this.port);
        VirtualFileSystemFactory fileSystemFactory = new VirtualFileSystemFactory();
        Path userHomeDir = Optional.ofNullable(this.userHomePath).map(x$0 -> Paths.get(x$0, new String[0])).map(Path::toAbsolutePath).orElseGet(() -> Paths.get(String.format("target/%s/home/%s", this.getName(), this.user), new String[0]).toAbsolutePath());
        if (!Files.exists(userHomeDir, new LinkOption[0])) {
            try {
                Files.createDirectories(userHomeDir, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new CitrusRuntimeException("Failed to setup user home dir", (Throwable)e);
            }
        }
        fileSystemFactory.setUserHomeDir(this.user, userHomeDir);
        this.sshd.setFileSystemFactory((FileSystemFactory)fileSystemFactory);
        if (this.hostKeyPath != null) {
            Resource hostKey = FileUtils.getFileResource((String)this.hostKeyPath);
            if (hostKey instanceof Resources.ClasspathResource) {
                ClassLoadableResourceKeyPairProvider resourceKeyPairProvider = new ClassLoadableResourceKeyPairProvider(Collections.singletonList(hostKey.getLocation()));
                this.sshd.setKeyPairProvider((KeyPairProvider)resourceKeyPairProvider);
            } else {
                FileKeyPairProvider fileKeyPairProvider = new FileKeyPairProvider(Collections.singletonList(hostKey.getFile().toPath()));
                this.sshd.setKeyPairProvider((KeyPairProvider)fileKeyPairProvider);
            }
        } else {
            ClassLoadableResourceKeyPairProvider resourceKeyPairProvider = new ClassLoadableResourceKeyPairProvider(Collections.singletonList("org/citrusframework/ssh/citrus.pem"));
            this.sshd.setKeyPairProvider((KeyPairProvider)resourceKeyPairProvider);
        }
        List availableSignatureFactories = this.sshd.getSignatureFactoriesNames();
        availableSignatureFactories.add("ssh-dss");
        availableSignatureFactories.add("ssh-rsa");
        availableSignatureFactories.add("rsa-sha2-256");
        this.sshd.setSignatureFactoriesNames((Collection)availableSignatureFactories);
        boolean authFound = false;
        if (this.password != null) {
            this.sshd.setPasswordAuthenticator((PasswordAuthenticator)new SimplePasswordAuthenticator(this.user, this.password));
            authFound = true;
        }
        if (this.allowedKeyPath != null) {
            this.sshd.setPublickeyAuthenticator((PublickeyAuthenticator)new SinglePublicKeyAuthenticator(this.user, this.allowedKeyPath));
            authFound = true;
        }
        if (!authFound) {
            throw new CitrusRuntimeException("Neither 'password' nor 'allowed-key-path' is set. Please provide at least one");
        }
        ScpCommandFactory commandFactory = new ScpCommandFactory.Builder().withDelegate((session, command) -> new SshCommand(command, this.getEndpointAdapter(), this.endpointConfiguration)).build();
        commandFactory.addEventListener(this.getScpTransferEventListener());
        this.sshd.setCommandFactory((CommandFactory)commandFactory);
        ArrayList<SftpSubsystemFactory> subsystemFactories = new ArrayList<SftpSubsystemFactory>();
        SftpSubsystemFactory sftpSubsystemFactory = new SftpSubsystemFactory.Builder().build();
        sftpSubsystemFactory.addSftpEventListener(this.getSftpEventListener());
        subsystemFactories.add(sftpSubsystemFactory);
        this.sshd.setSubsystemFactories(subsystemFactories);
        try {
            this.sshd.start();
        }
        catch (IOException e) {
            throw new CitrusRuntimeException("Failed to start SSH server - " + e.getMessage(), (Throwable)e);
        }
    }

    protected ScpTransferEventListener getScpTransferEventListener() {
        return new AbstractScpTransferEventListenerAdapter(){};
    }

    protected SftpEventListener getSftpEventListener() {
        return new AbstractSftpEventListenerAdapter(){};
    }

    protected void shutdown() {
        try {
            this.sshd.stop();
        }
        catch (IOException e) {
            throw new CitrusRuntimeException("Failed to stop SSH server - " + e.getMessage(), (Throwable)e);
        }
    }

    public AbstractPollableEndpointConfiguration getEndpointConfiguration() {
        return this.endpointConfiguration;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
        this.endpointConfiguration.setPort(port);
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
        this.endpointConfiguration.setUser(user);
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
        this.endpointConfiguration.setPassword(password);
    }

    public String getAllowedKeyPath() {
        return this.allowedKeyPath;
    }

    public void setAllowedKeyPath(String allowedKeyPath) {
        this.allowedKeyPath = allowedKeyPath;
    }

    public String getHostKeyPath() {
        return this.hostKeyPath;
    }

    public void setHostKeyPath(String hostKeyPath) {
        this.hostKeyPath = hostKeyPath;
    }

    public String getUserHomePath() {
        return this.userHomePath;
    }

    public void setUserHomePath(String userHomePath) {
        this.userHomePath = userHomePath;
    }

    public SshMessageConverter getMessageConverter() {
        return this.messageConverter;
    }

    public void setMarshaller(SshMarshaller marshaller) {
        this.endpointConfiguration.setSshMarshaller(marshaller);
    }

    public void setMessageConverter(SshMessageConverter messageConverter) {
        this.messageConverter = messageConverter;
        this.endpointConfiguration.setMessageConverter(messageConverter);
    }
}

