/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.generate.dictionary;

import java.util.Map;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPathConstants;
import org.citrusframework.context.TestContext;
import org.citrusframework.variable.dictionary.xml.XpathMappingDataDictionary;
import org.citrusframework.xml.namespace.DefaultNamespaceContext;
import org.citrusframework.xml.xpath.XPathUtils;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class InboundXmlDataDictionary
extends XpathMappingDataDictionary {
    public <T> T translate(Node node, T value, TestContext context) {
        if (value instanceof String) {
            String toTranslate = !this.mappings.isEmpty() ? (String)this.translateIfPresent(node, value, context) : (String)value;
            if (toTranslate.equals(value)) {
                if (toTranslate.equals("true") || toTranslate.equals("false")) {
                    return (T)"@matches(true|false)@";
                }
                if (Character.isDigit(toTranslate.charAt(0))) {
                    return (T)"@isNumber()@";
                }
                if (toTranslate.startsWith("string")) {
                    return (T)"@notEmpty()@";
                }
            } else {
                return (T)toTranslate;
            }
        }
        return value;
    }

    private <T> T translateIfPresent(Node node, T value, TestContext context) {
        for (Map.Entry expressionEntry : this.mappings.entrySet()) {
            String expression = (String)expressionEntry.getKey();
            DefaultNamespaceContext namespaceContext = new DefaultNamespaceContext();
            namespaceContext.addNamespaces(context.getNamespaceContextBuilder().getNamespaceMappings());
            NodeList findings = (NodeList)XPathUtils.evaluateExpression((Node)node.getOwnerDocument(), (String)expression, (NamespaceContext)namespaceContext, (QName)XPathConstants.NODESET);
            if (findings == null || !this.containsNode(findings, node)) continue;
            return (T)this.convertIfNecessary((String)expressionEntry.getValue(), value, context);
        }
        return value;
    }

    private boolean containsNode(NodeList findings, Node node) {
        for (int i = 0; i < findings.getLength(); ++i) {
            if (!findings.item(i).equals(node)) continue;
            return true;
        }
        return false;
    }

    public void initialize() {
        super.initialize();
        this.mappings.put("//*[string-length(normalize-space(text())) > 0]", "@ignore@");
        this.mappings.put("//@*", "@ignore@");
    }
}

