/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.generate.xml;

import java.util.List;
import java.util.Optional;
import org.citrusframework.generate.TestGenerator;
import org.citrusframework.generate.provider.MessageActionProvider;
import org.citrusframework.generate.provider.ReceiveActionProvider;
import org.citrusframework.generate.provider.SendActionProvider;
import org.citrusframework.generate.provider.http.ReceiveHttpRequestActionProvider;
import org.citrusframework.generate.provider.http.ReceiveHttpResponseActionProvider;
import org.citrusframework.generate.provider.http.SendHttpRequestActionProvider;
import org.citrusframework.generate.provider.http.SendHttpResponseActionProvider;
import org.citrusframework.generate.provider.soap.ReceiveSoapRequestActionProvider;
import org.citrusframework.generate.provider.soap.ReceiveSoapResponseActionProvider;
import org.citrusframework.generate.provider.soap.SendSoapRequestActionProvider;
import org.citrusframework.generate.provider.soap.SendSoapResponseActionProvider;
import org.citrusframework.generate.xml.XmlTestGenerator;
import org.citrusframework.http.message.HttpMessage;
import org.citrusframework.message.Message;
import org.citrusframework.ws.message.SoapMessage;

public class MessagingXmlTestGenerator<T extends MessagingXmlTestGenerator>
extends XmlTestGenerator<T> {
    private String endpoint;
    private Message request;
    private Message response;

    @Override
    protected List<Object> getActions() {
        List<Object> actions = super.getActions();
        if (this.getMode().equals((Object)TestGenerator.GeneratorMode.CLIENT)) {
            actions.add(this.getSendRequestActionProvider(this.request).getAction(Optional.ofNullable(this.endpoint).orElseGet(() -> this.getMode().name().toLowerCase()), this.generateOutboundMessage(this.request)));
            if (this.response != null) {
                actions.add(this.getReceiveResponseActionProvider(this.response).getAction(Optional.ofNullable(this.endpoint).orElseGet(() -> this.getMode().name().toLowerCase()), this.generateInboundMessage(this.response)));
            }
        } else if (this.getMode().equals((Object)TestGenerator.GeneratorMode.SERVER)) {
            actions.add(this.getReceiveRequestActionProvider(this.request).getAction(Optional.ofNullable(this.endpoint).orElseGet(() -> this.getMode().name().toLowerCase()), this.generateInboundMessage(this.request)));
            if (this.response != null) {
                actions.add(this.getSendResponseActionProvider(this.response).getAction(Optional.ofNullable(this.endpoint).orElseGet(() -> this.getMode().name().toLowerCase()), this.generateOutboundMessage(this.response)));
            }
        }
        return actions;
    }

    protected Message generateInboundMessage(Message message) {
        return message;
    }

    protected Message generateOutboundMessage(Message message) {
        return message;
    }

    protected <T, M extends Message> MessageActionProvider<T, M> getSendRequestActionProvider(M message) {
        if (message instanceof HttpMessage) {
            return new SendHttpRequestActionProvider();
        }
        if (message instanceof SoapMessage) {
            return new SendSoapRequestActionProvider();
        }
        return new SendActionProvider();
    }

    protected <T, M extends Message> MessageActionProvider<T, M> getReceiveResponseActionProvider(M message) {
        if (message instanceof HttpMessage) {
            return new ReceiveHttpResponseActionProvider();
        }
        if (message instanceof SoapMessage) {
            return new ReceiveSoapResponseActionProvider();
        }
        return new ReceiveActionProvider();
    }

    protected <T, M extends Message> MessageActionProvider<T, M> getSendResponseActionProvider(M message) {
        if (message instanceof HttpMessage) {
            return new SendHttpResponseActionProvider();
        }
        if (message instanceof SoapMessage) {
            return new SendSoapResponseActionProvider();
        }
        return new SendActionProvider();
    }

    protected <T, M extends Message> MessageActionProvider<T, M> getReceiveRequestActionProvider(M message) {
        if (message instanceof HttpMessage) {
            return new ReceiveHttpRequestActionProvider();
        }
        if (message instanceof SoapMessage) {
            return new ReceiveSoapRequestActionProvider();
        }
        return new ReceiveActionProvider();
    }

    public T withEndpoint(String endpoint) {
        this.endpoint = endpoint;
        return (T)((MessagingXmlTestGenerator)this.self);
    }

    public T withRequest(Message request) {
        this.request = request;
        return (T)((MessagingXmlTestGenerator)this.self);
    }

    public T withResponse(Message response) {
        this.response = response;
        return (T)((MessagingXmlTestGenerator)this.self);
    }

    public T addRequestHeader(String name, Object value) {
        this.request.setHeader(name, value);
        return (T)((MessagingXmlTestGenerator)this.self);
    }

    public T addResponseHeader(String name, Object value) {
        this.request.setHeader(name, value);
        return (T)((MessagingXmlTestGenerator)this.self);
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    public String getEndpoint() {
        return this.endpoint;
    }
}

