/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.generate.xml;

import jakarta.xml.bind.JAXBElement;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.xml.namespace.QName;
import javax.xml.transform.Result;
import org.citrusframework.generate.AbstractTemplateBasedTestGenerator;
import org.citrusframework.generate.TestGenerator;
import org.citrusframework.generate.javadsl.JavaTestGenerator;
import org.citrusframework.generate.xml.TestActionMarshaller;
import org.citrusframework.model.testcase.core.EchoActionType;
import org.citrusframework.model.testcase.core.ObjectFactory;
import org.citrusframework.spi.Resource;
import org.citrusframework.spi.Resources;
import org.citrusframework.xml.StringResult;

public class XmlTestGenerator<T extends XmlTestGenerator>
extends AbstractTemplateBasedTestGenerator<T> {
    private TestGenerator.GeneratorMode mode = TestGenerator.GeneratorMode.CLIENT;
    private volatile TestActionMarshaller marshaller;

    public XmlTestGenerator() {
        this.withFileExtension(".xml");
    }

    @Override
    public T withMode(TestGenerator.GeneratorMode mode) {
        this.mode = mode;
        return (T)((XmlTestGenerator)this.self);
    }

    protected List<String> getMarshallerContextPaths() {
        ArrayList<String> contextPaths = new ArrayList<String>();
        contextPaths.add(ObjectFactory.class.getPackage().getName());
        return contextPaths;
    }

    protected List<Resource> getMarshallerSchemas() {
        ArrayList<Resource> schemas = new ArrayList<Resource>();
        schemas.add(Resources.create((String)"org/citrusframework/schema/citrus-testcase.xsd"));
        return schemas;
    }

    @Override
    public void create() {
        super.create();
        this.getJavaTestGenerator().create();
    }

    @Override
    protected Properties getTemplateProperties() {
        Properties properties = super.getTemplateProperties();
        properties.put("test.actions", this.getActions().stream().map(action -> {
            StringResult result = new StringResult();
            this.createMarshaller().marshal(action, (Result)result);
            return Pattern.compile("^", 8).matcher(result.toString()).replaceAll("        ");
        }).collect(Collectors.joining("\n\n")));
        return properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TestActionMarshaller createMarshaller() {
        if (this.marshaller == null) {
            XmlTestGenerator xmlTestGenerator = this;
            synchronized (xmlTestGenerator) {
                this.marshaller = new TestActionMarshaller(this.getMarshallerSchemas().toArray(new Resource[0]), this.getMarshallerContextPaths().toArray(new String[0]));
            }
        }
        return this.marshaller;
    }

    protected List<Object> getActions() {
        ArrayList<Object> actions = new ArrayList<Object>();
        EchoActionType echo = new EchoActionType();
        echo.setMessage("TODO: Code the test " + this.getName());
        actions.add(new JAXBElement(new QName("http://www.citrusframework.org/schema/testcase", "echo"), EchoActionType.class, (Object)echo));
        return actions;
    }

    protected TestGenerator getJavaTestGenerator() {
        return new JavaTestGenerator().withName(this.getName()).withDisabled(this.isDisabled()).withDescription(this.getDescription()).withAuthor(this.getAuthor()).withFramework(this.getFramework()).usePackage(this.getTargetPackage()).useSrcDirectory(super.getSrcDirectory());
    }

    @Override
    protected String getTemplateFilePath() {
        return "classpath:org/citrusframework/generate/test-template.xml";
    }

    @Override
    public String getSrcDirectory() {
        return super.getSrcDirectory() + File.separator + "resources";
    }

    public void setMarshaller(TestActionMarshaller marshaller) {
        this.marshaller = marshaller;
    }

    public TestActionMarshaller getMarshaller() {
        return this.marshaller;
    }

    @Override
    public TestGenerator.GeneratorMode getMode() {
        return this.mode;
    }

    public void setMode(TestGenerator.GeneratorMode mode) {
        this.mode = mode;
    }
}

